/*
	fade.c - animate fade

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static XColor xcs[256];
static int mapsize;

#if defined(__STDC__) || defined(__cplusplus)
void PreFadeColors(int ms)
#else
void PreFadeColors(ms)
int ms;
#endif
{
int i;

	/* PseudoColor Only */
	if(theVisual->class == PseudoColor){
		for(i = 0; i < ms; i++){
			xcs[i].red	 = xcolors[i].red;
			xcs[i].green = xcolors[i].green;
			xcs[i].blue	 = xcolors[i].blue;
			xcs[i].flags = xcolors[i].flags;
			xcs[i].pixel = xcolors[i].pixel;
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
void FadeColors(int mode, int ms)
#else
void FadeColors(mode, ms)
int mode,ms;
#endif
{
int i,j;

	if(theVisual->class == PseudoColor){
		if(mode){

			for(j=255; j > 0; j -= app_data.fadeSteps){

				for(i=0;i<ms;i++){
					fcolors[i].red	=(word)((int)xcs[i].red   * j / 255);
					fcolors[i].green=(word)((int)xcs[i].green * j / 255);
					fcolors[i].blue =(word)((int)xcs[i].blue  * j / 255);
					fcolors[i].flags=xcs[i].flags;
					fcolors[i].pixel=xcs[i].pixel;
				}
				StoreColors(fcolors,ms);
				myusleep(app_data.fadeTicks);
				if(gotSomeAction == True)
					return;
			}

		}
		else{

			for(j=0; j < 255; j += app_data.fadeSteps){

				for(i=0;i<ms;i++){
					fcolors[i].red	=(word)((int)xcs[i].red   * j / 255);
					fcolors[i].green=(word)((int)xcs[i].green * j / 255);
					fcolors[i].blue =(word)((int)xcs[i].blue  * j / 255);
					fcolors[i].flags=xcs[i].flags;
					fcolors[i].pixel=xcs[i].pixel;
				}
				StoreColors(fcolors,ms);
				myusleep(app_data.fadeTicks);
				if(gotSomeAction == True)
					return;
			}

		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xfadeshow(char *fname)	/* Fade in */
#else
ActionStatus xfadeshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(	(windowWidth-gim.subImageList->width)/2,
				(windowHeight-gim.subImageList->height)/2,
				gim.subImageList->width,gim.subImageList->height);

	PreFadeColors(mapsize);
	FadeColors(False,mapsize);
	StoreColors(xcolors,mapsize);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxfadeshow(char *fname)	/* Fade out */
#else
void postxfadeshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True,mapsize);
}

