#! /usr/bin/env python
# ZShellCLI - (c) 2001 Andy McKay
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# This software is now part of Jerome Alet's ZShell

#
# $Id: ZShellCLI.py,v 1.4 2001/08/30 13:09:10 jerome Exp $
#
# $Log: ZShellCLI.py,v $
# Revision 1.4  2001/08/30 13:09:10  jerome
# CVS Id and Log markers added
#
#

import cmd, sys, os, string, tempfile

# I have to insert this to get access to xmlrpclib, you may not
sys.path.insert(0, r'e:\Zope23\lib\python')

import xmlrpclibBasicAuth

default_prompt = '> '

class ZShellCLI(cmd.Cmd):
    def __init__(self, *args):
	''' setup '''
	self.prompt = default_prompt
	self.path = ''
	self.connect = None

    def do_open(self, line):
	'''
	means typing password in clear text
	need to look at Cmd module to see if we
	can type this in sep.
	maybe config file to load this in?
	'''
	# syntax: open http://127.0.0.1 user pwd
	(url, user, pwd) = string.split(line, ' ')
	self.base_prompt = string.split(url, '/')[-1]
	self.prompt = self.base_prompt + '> '
	self.connect = xmlrpclibBasicAuth.Server(url, user, pwd)
	print "Connected to %s" % url

    def do_close(self, line):
	self.connect = None
	print "Disconnected from %s" % self.base_prompt
	self.prompt = default_prompt

    def do_exit(self, line):
	sys.exit() # bye

    def do_quit(self, line):
	sys.exit() # bye

    def show_browser(self, data):
	''' creates a make file and shoves it in '''
	filename = tempfile.mktemp()
	file = open(filename, 'w')
	data = string.join(string.split(data, '\n')[1:], '\n')
	file.write(data)
	file.close()
	os.system('explorer %s' % filename)

    def set_path(self, path):
	''' change path, set a nice prompt '''
	self.path = path
	self.prompt = "%s%s> " % (self.base_prompt, self.path)

    def run_cmd(self, command):
	''' runs a command, changes path '''
	if self.connect is not None:
	    info = { 'command': command, 'result_type': 'text', 'path': self.path }
	    output = self.connect.zshell('', info)
	    self.set_path(output['path'])
	    return output['data']
	else:
	    return "Not Connected"

    def default(self, line):
	print self.run_cmd(command=line)

    def emptyline(self):
	pass

    def preloop(self):
	''' hello '''
	print
	print "ZShellCLI: A CLI to ZShell"

if __name__ == '__main__':
    shell = ZShellCLI()
    try:
	# go!
	shell.cmdloop()
    except KeyboardInterrupt:
	sys.exit()

