##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from global_symbols import *

import ZAbstractAttachment
import ZAttachmentRegistry

attach_globals = globals()

class ZDummyAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    ZDummyAttachment -> This class simulates an empty attachment so that ValueErrors won't be called whenever
    ZAttachmentAttribute's __underlyingFile__ will be None...
    """

    # attachment properties (MUST BE DERIVEd
    icon_file = "unknown.gif"
    small_icon_file = "unknown_small.gif"
    content_types = ()

    def indexAttachment(self,):
        """
        indexAttachment(self,) => string or list of strings
        Return the ZCatalog-indexable string for that type.
        """
        return ""

    def isPreviewAvailable(self,):
        """
        No preview for dummy attachements
        """
        return 0

    def convertPreview(self,):
        """
        No preview
        """
        return None

        


ZAttachmentRegistry.AttachmentRegistry.registerClass(ZDummyAttachment, globals(), None)
