# check for converter modules

import os, popen2
from commands import getoutput

from zLOG import LOG, INFO, WARNING
from Products.TextIndexNG2.Registry import ConverterRegistry

converters = os.listdir(__path__[0])
converters = [ c for c in converters if c.endswith('.py') and c!='__init__.py' ]

for cv in converters:

    cv = cv[:-3]
    mod = __import__(cv, globals(), globals(), __path__)
    if not hasattr(mod,'Converter'): continue

    converter = mod.Converter()
    for t in converter.getType():
        depends_on = getattr(converter, 'depends_on', None)
        if depends_on and os.name == 'posix':
            r,w,e = popen2.popen3('which %s' % depends_on)
            out = r.read() + e.read()
            if out.find('no %s' % depends_on) > - 1 or out.lower().find('not found') > -1 or len(out.strip()) == 0:
                LOG('textindexng', WARNING, 'Converter "%s" not registered because executable "%s" could not be found' % (cv, depends_on))
            else:
                ConverterRegistry.register(t, converter)
                LOG('textindexng', INFO, 'Converter "%s" for %s registered' % (cv, t))
        else:
            ConverterRegistry.register(t, converter)
            LOG('textindexng', INFO, 'Converter "%s" for %s registered' % (cv, t))

del converters
