import Globals
import zLOG

try:
    dummy=True
except NameError:
    True=1
    False=0

from config import *

# don't use psyco in development mode -- it messes up pdb.set_trace()
if Globals.DevelopmentMode:
    USE_PSYCO = False

GLOBALS = globals()

if USE_PSYCO:
    import psyco_optimisation
    success = psyco_optimisation.optimise(profile=False)
    if success:
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Enabling psyco. If you experience problems with Archetypes, set USE_PSYCO in Speedpack/config.py to 0')
    else:
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Psyco not found.  You can speed up Plone with psyco. Download from http://psyco.sourceforge.net/')

def monkeyPatch(originalClass, patchingClass):
    """Monkey patch original class with attributes from new class
    
    * Takes all attributes and methods except __doc__ and __module__ from patching class
    * Safes original attributes as _monkey_name
    * Overwrites/adds these attributes in original class
    """
    for name, newAttr in patchingClass.__dict__.items():
        # don't overwrite doc or module informations
        if name not in ('__doc__', '__module__'):
            # safe the old attribute as __monkey_name if exists
            # __dict__ doesn't show inherited attributes :/
            orig = getattr(originalClass, name, None)
            if orig:
                stored_orig_name = '_monkey_%s' % name
                stored_orig = getattr(originalClass, stored_orig_name, None)
                # don't double-patch on refresh!
                if stored_orig is None:
                    originalClass.__dict__[stored_orig_name] = orig
            # overwrite or add the new attribute
            originalClass.__dict__[name] = newAttr

if PATCH_CMF:
    from Portal import SitePatch
    try:
        #from Products.CMFPlone.Portal import PloneSite as OldSite
        from Products.CMFDefault.Portal import CMFSite as OldSite
    except ImportError:
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Cannot patch CMF Site')
    else:
        monkeyPatch(OldSite, SitePatch)
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Patched CMF Site')

    from SkinsTool import SkinsToolPatch
    try:
        #from Products.CMFPlone.SkinsTool import SkinsTool as OldSkinsTool
        from Products.CMFCore.SkinsTool import SkinsTool as OldSkinsTool
    except ImportError:
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Cannot patch CMF Skins Tool')
    else:
        monkeyPatch(OldSkinsTool, SkinsToolPatch)
        zLOG.LOG('SpeedPack', zLOG.INFO, '', 'Patched CMF Skins Tool')

def initialize(context):
    import SkinsCustomFolder
    SkinsCustomFolder.register(context, GLOBALS)

