# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is RDFGrabber version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by EEA are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
#

from sys import argv
import rdfparser
from objects import *

# Constants for the tupples in ICanAdd()
SUBJECT=0
PREDICATE=1
OBJECT=2

class SPO:
    def __init__(self, subject,predicate,object):
        self._subject = subject
        self._predicate = predicate
        self._object = object

    def strsubject(self):
        return str(self._subject)
    def strpredicate(self):
        return str(self._predicate)
    def strobject(self):
        return str(self._object)

    def subject(self):
        return self._subject
    def predicate(self):
        return self._predicate
    def object(self):
        return self._object


class RDFGrabber:
    def __init__(self):
	self.triples = []
	self.subjects = {}
	self.predicates = {}
	self.objects = {}

    def ICanAdd(self,subject, predicate, object):
	# Assume spo is shared in all dictionaries
	spo = SPO(subject, predicate, object)

	if object.is_literal():
	    print '<%s> <%s> "%s (%s)" .' % (subject, predicate, object,object.lang)
	else:
	    print "<%s> <%s> <%s> ." % (subject, predicate, object)

        self.triples.append(spo)

	x = str(subject)
	if not self.subjects.has_key(x):
	    self.subjects[x] = []
	self.subjects[x].append(spo)

	x = str(predicate)
	if not self.predicates.has_key(x):
	    self.predicates[x] = []
	self.predicates[x].append(spo)

	x = str(object)
	if not self.objects.has_key(x):
	    self.objects[x] = []
	self.objects[x].append(spo)

    def lookup_predicate(self,predicate):
        if not self.predicates.has_key(predicate):
            return []
        return self.predicates[predicate]

    def dumbdown(self,spo,list=[]):
	for i in spo:
	    if i[4] == 0:
		if i[1] == "http://www.w3.org/1999/02/22-rdf-syntax-ns#value" \
		or i[1][:44] == "http://www.w3.org/1999/02/22-rdf-syntax-ns#_":
		    list.append(i[2])
	    else:
		self.dumbdown(self.subjects[i[2]],list)
	return list

    def runtest(self,argv):
	p=rdfparser.RDFParser(self.ICanAdd)
	for arg in argv[1:]:
	    p.parse_url(arg)

r = RDFGrabber()
r.runtest(argv)

s = r.lookup_predicate("http://purl.org/metadata/dublin_core#Publisher")
if s != []:
    print s[0].subject()

#print "TRIPLES"
#for x in r.triples:
#   print "(%s | %s | %s)" % ( x[SUBJECT], x[PREDICATE], x[OBJECT][0:20] )
#   print "(%s | %s | %s)" % ( x[SUBJECT][0:20], x[PREDICATE][0:20], x[OBJECT][0:20] )

#print "NOW WE FIND THE TITLE IN THE DICTIONARIES"
#for x in r.predicates['http://purl.org/metadata/dublin_core#Title']:
#    print x[OBJECT]
#print r.predicates
#r.list=[]
#print "DUMB DOWN OF genid:1"
#print r.dumbdown(r.objects["genid:1"])
