/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999-2000 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: ThemeManager.cpp,v 1.10 2003/09/16 17:36:23 kgk Exp $
____________________________________________________________________________*/ 

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <string>

#ifndef WIN32
#include <unistd.h>
#define _stat stat
#ifndef _S_IFDIR
#define _S_IFDIR S_IFDIR
#endif
#endif

using namespace std;
#include "path_max.h"
#include "ThemeManager.h"
#include "ThemeZip.h"
#include "utility.h"
#include "win32impl.h"

#ifdef __QNX__
#include <strings.h>
#endif

#define THEME_IN_DEVEL "<theme in development>"

ThemeManager::ThemeManager(FAContext *pContext)
{
    string szTheme;
    Error eRet;

    m_pContext = pContext;
    m_oCurrentTheme = "";
    m_bDevelTheme = false;

    
    eRet = pContext->prefs->GetPrefString(kThemePref, szTheme);
    if (IsError(eRet) || !szTheme.length()) {
        m_oCurrentTheme = BRANDING_DEFAULT_THEME;
    }
    else {
        struct stat buf;

        m_oCurrentTheme = szTheme;
        if (stat(szTheme.c_str(), &buf) == 0 && S_ISDIR(buf.st_mode)) {
            m_bDevelTheme = true; 
            m_oDevelTheme = m_oCurrentTheme;
            m_oCurrentTheme = THEME_IN_DEVEL;
        }
    }
}

ThemeManager::~ThemeManager(void)
{
}

Error ThemeManager::GetDefaultTheme(string &themeName, string &oThemePath)
{
    map<string, string> oThemeList;
    GetThemeList(oThemeList);

    // Load up a list of themes to try
    vector<string> themes;
    if (m_pContext->prefs->GetPrefString(kThemePref, themeName) 
        !=  kError_NoPrefValue){
        themes.push_back (themeName);
    }
    themes.push_back( BRANDING_DEFAULT_THEME );
    // Any theme we have
    map<string, string>::iterator i;
    for (i = oThemeList.begin(); i != oThemeList.end(); i++) {
        themes.push_back( (*i).first );
    }
    // Now try in order.
    struct  _stat buf;
    vector<string>::iterator ti = themes.begin();
    for (; ti != themes.end(); ti++){
        themeName = *ti;
        oThemePath = oThemeList[themeName];
        if (oThemePath.size() 
            && _stat(oThemePath.c_str(), &buf) == 0) 
            break;
    }    

//     fprintf(stderr, "default theme %s %s\n", themeName.c_str(), oThemePath.c_str());

    if (oThemePath.size() == 0) 
        return kError_FileNotFound;
    
    return kError_NoErr;
}

Error ThemeManager::GetThemeList(map<string, string> &oThemeFileMap)
{
    WIN32_FIND_DATA find;
    HANDLE          handle;
    string 	    dir;
    char 	    *ptr;
    string          oThemePath, oThemeBasePath, oThemeFile;

    if (m_bDevelTheme)
        oThemeFileMap[THEME_IN_DEVEL] = m_oDevelTheme;


    string themedirs;
    m_pContext->prefs->GetPrefString(kThemePathPref, themedirs);
    const vector<string> dirs = SplitPath(themedirs);


    // Installation 
#if 0
    oThemeBasePath = dir + "/" + BRANDING_SHARE_PATH + "/themes";
    dirs.push_back (oThemeBasePath);

    // 
    char *fadir = ZinfDir(NULL);
    oThemeBasePath = string(fadir) + "/themes";
    delete [] fadir;
    struct stat st;
    if (-1 == stat(oThemeBasePath.c_str(), &st))
        mkdir(oThemeBasePath.c_str(), 0755);
    dirs.push_back (oThemeBasePath);


    oThemeBasePath = "~/.zinf/themes";
    dirs.push_back (oThemeBasePath);
#endif    
    
    vector<string>::const_iterator di = dirs.begin();
    for (; di != dirs.end(); di++) {
        string base   = *di;
        //base += "/themes/";
        string search = base;
        search += "/*.*";


        //fprintf(stderr, "trying %s\n", search.c_str());
        handle = FindFirstFile((char *)search.c_str(), &find);
        if(handle != INVALID_HANDLE_VALUE) {
            do {
                oThemeFile = base + '/' + find.cFileName;
                ptr = strrchr(find.cFileName, '.');
                if (ptr) {
                    ptr++;
                    if (!strcasecmp("fat", ptr) || !strcasecmp("zip", ptr) ||
                        !strcasecmp("wsz", ptr))
                        if (oThemeFileMap[find.cFileName].size() == 0){
                            oThemeFileMap[find.cFileName] = oThemeFile;
                            //fprintf(stderr, "adding %s at %s\n" , find.cFileName , oThemeFile.c_str());
                        } else {
                            //fprintf (stderr, "skipping duplicate theme\n");
                            ;
                        }
                }
            } while(FindNextFile(handle, &find));
            FindClose(handle);
        }
    }

#if 0
    char *fadir = ZinfDir(NULL);
    oThemeBasePath = string(fadir) + string("/themes");
    delete [] fadir;

    struct stat st;
    if (-1 == stat(oThemeBasePath.c_str(), &st))
        mkdir(oThemeBasePath.c_str(), 0755);
    oThemePath = oThemeBasePath + string("/*.*");
    handle = FindFirstFile((char *)oThemePath.c_str(), &find);
    if (handle != INVALID_HANDLE_VALUE) {
        do {
            oThemeFile = oThemeBasePath + string("/") + string(find.cFileName);
            ptr = strrchr(find.cFileName, '.');
            if (ptr) {
               *ptr = 0;
               ptr++;
            }
            if (ptr && *ptr) {
                if (!strcasecmp("fat", ptr) || !strcasecmp("zip", ptr) ||
                    !strcasecmp("wsz", ptr))
                    oThemeFileMap[find.cFileName] = oThemeFile;
            }
        }
        while(FindNextFile(handle, &find));
        FindClose(handle);
    }

    oThemeBasePath = "~/.zinf/themes";
    oThemePath = oThemeBasePath + string("/*.*");
    handle = FindFirstFile((char *)oThemePath.c_str(), &find);
    if (handle != INVALID_HANDLE_VALUE) {
        do {
            oThemeFile = oThemeBasePath + string("/") + string(find.cFileName);
            ptr = strrchr(find.cFileName, '.');
            if (ptr) {
               *ptr = 0;
               ptr++;
            }
            if (ptr && *ptr) {
                if (!strcasecmp("fat", ptr) || !strcasecmp("zip", ptr) ||
                    !strcasecmp("wsz", ptr))
                    oThemeFileMap[find.cFileName] = oThemeFile;
            }
        }
        while(FindNextFile(handle, &find));
        FindClose(handle);
    }
#endif
    return kError_NoErr;
}

Error ThemeManager::UseTheme(string &themePath)
{
#if 0
    char   dir[_MAX_PATH];
    string oThemePath;


    char *temp_dir;
    temp_dir = strrchr(oThemeFile.c_str(), '/');
    if (temp_dir) {
        temp_dir = temp_dir + 1;
        strcpy(dir, temp_dir);
        if (oThemeFile == m_oCurrentTheme)
        {
            return kError_NoErr;
        }
    }
#endif

    string name = themePath;
    string::size_type sl = name.rfind ('/');
    if (sl != string::npos) 
        name = name.substr(sl+1);

    m_pContext->prefs->SetPrefString(kThemePref, name);
    m_oCurrentTheme = name;
    
    return kError_NoErr;
}

Error ThemeManager::AddTheme(string &themefile, bool bRename)
{
    string themedest;
    bool   bRenameFailed = false;
    //char fcopy[_MAX_PATH], *filename = NULL, *ext = NULL;

    char *fadir = ZinfDir(NULL);
    themedest = fadir;
    themedest += "/themes";
    delete [] fadir;

    struct stat st;
    if (-1 == stat(themedest.c_str(), &st))
        mkdir(themedest.c_str(), 0755);


    string   name;
    if (bRename)
    {
        ThemeZip oZip;

        if (IsntError(oZip.GetDescriptiveName(themefile, name)) &&
            name.length() > 0)
        {
            int i;

            for(i = name.length() - 1; i >= 0; i--)
                if (!isalnum(name[i]) && name[i] != ' ')
                    name.erase(i, 1);

            themedest += string("/") + name + string(".fat");
        }
        else
            bRenameFailed = true;
    }

    if (!bRename || bRenameFailed)
    {
        string::size_type spot = themefile.rfind ('/');
        if (spot != string::npos) 
            name = themefile.substr(spot+1);
        else
            name = "unkown.fat";

        themedest += '/';
        themedest += name;
        
#if 0
        strcpy(fcopy, themefile.c_str());
        filename = strrchr(fcopy, '/');
        if (filename)
            filename = filename + 1;
        else
            filename = fcopy;
        ext = strrchr(filename, '.');
        if (ext) {
            *ext = '\0';
            ext++;
        }

        themedest += string("/");
        if (!filename)
            themedest += string("unknown");
        else
            themedest += string(filename);
        if (ext)
            themedest += string(".") + string(ext);   
#endif
    }
    printf ("copying %s to %s\n", themefile.c_str(), themedest.c_str());
    if (!CopyFile(themefile.c_str(), themedest.c_str(), false))
        return kError_FileNotFound;

    // So the caller knows where the theme ended up
    themefile = themedest;
    
    return kError_NoErr;
}

Error ThemeManager::DeleteTheme(string &oThemeFile)
{
    return unlink(oThemeFile.c_str()) == 0 ? kError_NoErr : kError_UnlinkFailed;
}

Error ThemeManager::GetCurrentTheme(string &oTheme)
{
    oTheme = m_oCurrentTheme;
    return kError_NoErr;
}

/* arch-tag: fdabf93a-dc58-4d0b-a779-e9450bb39125
   (do not change this comment) */
