/*____________________________________________________________________________
        
   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 2000 EMusic.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
        
   $Id: Headlines.h,v 1.4 2003/09/16 17:35:32 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_SLASHDOT_H
#define INCLUDED_SLASHDOT_H

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#include "config.h"
#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include <vector>
#include <string>
#include <time.h>
#include "thread.h" 
#include "semaphore.h" 
#include "Parse.h" 
#include "facontext.h"

class HeadlineInfo
{
    public:

        HeadlineInfo(void) { ; };
        HeadlineInfo(const std::string &oUrl,
                     const std::string &oXMLPath, 
                     const std::string &oXMLURLPath, 
                     int iDownloadInterval,
                     int iHeadlineChangeInterval);
        virtual ~HeadlineInfo();

        void   operator=(const HeadlineInfo &oOther);

        std::string m_oUrl, m_oXMLPath, m_oXMLURLPath;
        int    m_iDownloadInterval, m_iHeadlineChangeInterval;
};

class Headlines : public Parse
{
    public:

        Headlines(FAContext * context);
        virtual ~Headlines();

        void        SetInfo(HeadlineInfo &oInfo);
        void        Pause(void);
        void        Resume(void);
        static void worker_thread(void*);

    protected:

        virtual Error BeginElement(std::string &oElement, AttrMap &oAttrMap);
        virtual Error PCData(std::string &oData);
        virtual Error EndElement(std::string &oElement);

        void   WorkerThread(void);
        Error  Download(void);
        Error  DownloadHeadlines(std::string &oUrl, std::string &oPage);

        FAContext       *m_pContext;
        Thread          *m_pThread;
        std::string           m_oPath;
        std::vector<std::string>   m_oHeadlines, m_oHeadlineURLs;
        bool             m_bPause;
        Semaphore       *m_pWakeSem;
		HeadlineInfo     m_oInfo;
		time_t           m_lLastDownload;
		int              m_iIndex;
};

#endif

/* arch-tag: 06040830-f822-45bb-8909-c1ed10119d6d
   (do not change this comment) */
