#ifndef INCLUDED_GTKPLAYLIST_H_
#define INCLUDED_GTKPLAYLIST_H_

#include <vector>
#include <string>
#include <gtkmm/menu.h>
#include <pangomm/fontdescription.h>
#include <time.h>

#include "event.h"
#include "playlist.h"
#include "facontext.h"
#include "gtkmusiclist.h"

class GTKBrowserMusic;

class GTKPlaylist : public GTKMusicList {
 public:
	GTKPlaylist(FAContext *context, PlaylistManager *plm, GTKBrowserMusic *musicbrowser);
	
	//Public Functions
	Error AcceptEvent(Event *event);
	
	void CheckCurrentIndex();

	PlaylistManager* GetPLM() { return m_plm; }
	void SetLoadingPlaylist() { loading_playlist = true; }
	void SetPlaylistModified(bool changed) { playlist_changed = changed; }
	bool GetPlaylistModified() { return playlist_changed; }
	
	//Functions Called By Menu, Toolbar, ...
	void DoEditTrack() { on_menu_editinfo(); }
	void DoRemove() { on_menu_remove(); }
 private:
	FAContext *m_context;
	GTKBrowserMusic *m_musicbrowser;
 	PlaylistManager *m_plm;
	bool m_editing_rows;
 	bool playlist_changed;
 	bool loading_playlist;
 	time_t last_update;
	
	//Functions To Respond To Player Events
	virtual void set_list_columns();
 	void PlaylistChanged(bool mark_as_changed = true);
 	void PlaylistLengthChanged();
	bool IndexListed(uint32_t Index);
	
	//Menu Stuff
	virtual void show_menu(guint button, guint32 time);
	Gtk::Menu m_Menu;
	void on_menu_play();
	void on_menu_moveup();
	void on_menu_movedown();
	void on_menu_remove();
	void on_menu_editinfo();
	
	//Functions To Respond To UI Events
	virtual void row_activated(Gtk::TreeModel::Path RowPath);
	virtual void set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths);
	
	//Stuff To Do With Moving Items
	/* When Item Moved By Dragging, Insert Signal New Position, Then Deleted Old Position +/- 1 */
	Gtk::TreeModel::Path m_last_inserted;
	void row_deleted(const Gtk::TreeModel::Path& path);
	void row_inserted(const Gtk::TreeModel::Path& path, const Gtk::TreeModel::iterator& iter);

	//Class Defining Possible Columns
	class PlaylistColumns : public Gtk::TreeModel::ColumnRecord {
	 public:
		
		PlaylistColumns() 
		{ add(playlistposition); add(artist); add(album); add(comment); add(genre); add(location); add(title); add(time); add(track); add(year); add(fontweight); add(last_refresh); } 
		
		Gtk::TreeModelColumn<Glib::ustring> playlistposition;
		Gtk::TreeModelColumn<Glib::ustring> artist;
		Gtk::TreeModelColumn<Glib::ustring> album;
		Gtk::TreeModelColumn<Glib::ustring> comment;
		Gtk::TreeModelColumn<Glib::ustring> genre;
		Gtk::TreeModelColumn<Glib::ustring> location;
		Gtk::TreeModelColumn<Glib::ustring> title;
		Gtk::TreeModelColumn<Glib::ustring> time;
		Gtk::TreeModelColumn<Glib::ustring> track;
		Gtk::TreeModelColumn<Glib::ustring> year;
		Gtk::TreeModelColumn<Pango::Weight> fontweight;
		Gtk::TreeModelColumn<time_t> last_refresh;
	};
	PlaylistColumns m_PlaylistCols;
};

#endif
/* arch-tag: 6b3e5d16-d9c7-4b08-ab77-db7d607bd96a */
