/*____________________________________________________________________________

    Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

    Portions Copyright (C) 1999-2000 EMusic.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: gtkmusicbrowser.h,v 1.3 2003/09/16 17:58:15 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_GTKMUSICBROWSER_H_
#define INCLUDED_GTKMUSICBROWSER_H_

#include <string>
#include <vector>

#include <gtkmm/window.h>
#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>
#include <glibmm/refptr.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>

#include "ui.h"
#include "event.h"
#include "thread.h"
#include "playlist.h"
#include "musiccatalog.h"
#include "timer.h"
#include "dialogs.h"
#include "gtklibrary.h"
#include "musiclayout.h"
#include "gtkplaylistnotebook.h"
#include "gtktoolbar.h"
#include "gtkstatusbar.h"
#include "gtkmenubar.h"

class FAContext;
class MusicBrowser;

class GTKBrowserMusic : public Gtk::Window {
 public:
	//Existing Used Public Interface
    GTKBrowserMusic(FAContext *context, MusicBrowser *masterUI, 
                    std::string playlistURL = "",
                    bool isMaster = false);
	~GTKBrowserMusic();

    void ShowMusicBrowser();
    bool Close(bool in_Main = true, bool hide_self = true, bool force = false);
 
    bool Visible(void) { return is_visible(); }
    Error AcceptEvent(Event *e);

	//Functions Called By Children: GTKToolbar, etc...
	void SetCurrentPLM(PlaylistManager *plm);
	void StartPlaying(bool set_index = false, uint32_t playlist_index = 0);
	void AddFromLibrary();
	void AddFiles();
	void EditTrack();
	void TracksToEdit(std::vector<PlaylistItem *> *Tracks);
	void TracksToEdit(std::vector<std::string> *URLs);
	void RemoveFromPlaylist();
	void ImportFiles();
	void NewPlaylist();
	void OpenPlaylist(std::string URL = "");
	void SavePlaylist(int playlist_num = -1, bool in_main = true);
	void SavePlaylistAs(int playlist_num = -1, bool in_main = true);
	void RevertToSavedPlaylist(int playlist_num = -1);
	void ClearPlaylist(int playlist_num = -1);
	void ClosePlaylist(int playlist_num = -1);
	bool CheckClosePlaylist(int playlist_num = -1, bool allow_cancel = true, bool in_main = true);
	
	void UpdateGUI(); //Processes All Waiting GTK Events - Must Be Called From Outside Main Loop, and inside gdk_threads_enter()
    void SearchMusic(const std::string& path);
    
	
	//Functions To Update Status Bar
	void StatusText(Glib::ustring NewText, uint32_t Pane);
	SigC::Connection m_TimeoutSignal;
	bool TimedClearStatusText();
	void UpdateListTime();

	//Shared Icons
	Glib::RefPtr<Gdk::Pixbuf> m_add_track_pic;
	Glib::RefPtr<Gdk::Pixbuf> m_catalog_pic;
	Glib::RefPtr<Gdk::Pixbuf> m_import_files_pic;
	Glib::RefPtr<Gdk::Pixbuf> m_edit_pic;

 protected:
	virtual void on_hide();
 
 private:

	//Internal Flags & Variables
	FAContext *m_context;
    MusicBrowser *m_parentUI;
	std::string m_playlistPath;
 	PlaylistManager *created_plm;
    PlaylistManager *m_plm;
 
	bool m_initialized;
	bool m_isMaster;
 	bool close_doing_hide;
	bool Save_Current_Playlist_On_Exit;
  
	//Internal Functions
 	void ChangeDisplayMode();
	void ReadPrefs();

	//File Dialog Stuff
	MusicFileSelector* m_filedialog;
 	void on_add_files_response(int response);
 	void on_import_files_response(int response);
	
	//GTK Widgets
	MusicLayout *m_layout;
	
	GTKPlaylistNotebook *m_bookPlaylists;
	GTKLibrary *m_treeLibrary;
	GTKToolbar *m_toolbar;
	GTKStatusBar m_StatusBar;
    GTKMenubar  m_menubar;

};

#endif
/* arch-tag: 53dd9ca7-665c-4444-94f9-631ec5c10a80 */
