/* zbuser.hh 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZBUSER_H
#define ZBUSER_H

#include <qwidget.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qvaluelist.h>

typedef struct tarifInfo
{
  QString name;
  float fullHour;
  float halfHour;
  float quartHour;
  float fullDay;
  float halfDay;
  unsigned int fullDayHours;
  unsigned int halfDayHours;
  int happyEnabled;
  float happyFullHour;
  float happyHalfHour;
  float happyQuartHour;
  QTime happyStart;
  QTime happyStop;
  int day[7];
  float tax;
  int vorlauf;
}
tarifInfo;
typedef QValueList < tarifInfo > tarifList;

typedef struct productInfo
{
  QString name;
  float price;
  float tax;
}
productInfo;
typedef QValueList < productInfo > productList;

typedef struct printInfo
{
  float tax;
  float color;
  float gray;
}
printInfo;

typedef struct userProdInfo
{
  int index;
  int count;
  QTime zeit;
}
userProdInfo;
typedef QValueList < userProdInfo > userProdList;

class zbuser:public QObject
{
Q_OBJECT 
public:
    zbuser (QString name, productList * pList, printInfo * prints,
	    bool isCountdown, QTime elapsed = QTime::currentTime ());
   ~zbuser ();
  void timeStart ();
  void timePause ();
  void timeStop ();
  void setTime (int h, int m);
  void setTarif (tarifInfo * tarif);
  void updateTarif (tarifInfo * tarif);
  void addItem (int index, int count);
  void addPrint (bool color, int count);
  float calcTarif ();
  bool isOn ();
  QString name ();
  userProdList usProdList;
  QString tarif();
  float getPrice();
  unsigned int colorPrint;
  unsigned int grayPrint;
  printInfo *pInfo;
  bool countdown;
  QString getTime();
private:
  float tarif_1 (int h, int m);
  float tarif_2 (int h, int m);
  float tarif_3 (int h, int m);
  float tarif_4 (int h, int m);
  float tarif_5 (int h, int m);
  float tarif_6 (int h, int m);
  float tarif_7 (int h, int m);
  float happy_1 (int h, int m);
  float happy_2 (int h, int m);
  float happy_3 (int h, int m);
  float happy_4 (int h, int m);
  float happy_5 (int h, int m);
  float happy_6 (int h, int m);
  float happy_7 (int h, int m);
  QTime subTime (QTime time1, QTime time2);
  QTime addTime (QTime time1, QTime time2);
private:
  QString userName;
  QTime startTime;
  QTime usedTime;
  QTime elapsedTime;
  QTimer *timer;
  tarifInfo *aktTarif;
  int tarifStatus;
  int happyStatus;
  float priceTime;
  float priceItems;
  productList *prods;
  bool running;
signals:
  void timeChanged (QTime);
  void priceChanged (float);
  void nameChanged (QString);
  void updateUser();
private slots:
  void slotTimeout ();
};

#endif
