/* printprice.cc */

#include "printprice.hh"
#include "icons/ok.xpm"
#include "icons/reject.xpm"

printprice::printprice (QWidget * parent, const char *name, bool modal,
			printInfo * pInfo, QString cur, bool write):
QDialog (parent, name, modal)
{
  QString buf;
  grid = new QGridLayout (this, 4, 3, 3, 3);
  lbTax = new QLabel (this);
  lbTax->setText (tr ("Tax"));
  grid->addWidget (lbTax, 0, 0);
  edTax = new QLineEdit (this);
  buf.setNum (pInfo->tax);
  edTax->setText (buf);
  edTax->setEnabled (write);
  grid->addWidget (edTax, 0, 1);
  cur1 = new QLabel (this);
  cur1->setText ("%");
  grid->addWidget (cur1, 0, 2);
  lbColor = new QLabel (this);
  lbColor->setText (tr ("Color"));
  grid->addWidget (lbColor, 1, 0);
  edColor = new QLineEdit (this);
  buf.setNum (pInfo->color);
  edColor->setText (buf);
  edColor->setEnabled (write);
  grid->addWidget (edColor, 1, 1);
  cur2 = new QLabel (this);
  cur2->setText (cur);
  grid->addWidget (cur2, 1, 2);
  lbGray = new QLabel (this);
  lbGray->setText (tr ("Grayscale"));
  grid->addWidget (lbGray, 2, 0);
  edGray = new QLineEdit (this);
  buf.setNum (pInfo->gray);
  edGray->setText (buf);
  edGray->setEnabled (write);
  grid->addWidget (edGray, 2, 1);
  cur3 = new QLabel (this);
  cur3->setText (cur);
  grid->addWidget (cur3, 2, 2);
  btnAccept = new QPushButton (this);
  icoOk = QPixmap (ok_xpm);
  btnAccept->setPixmap (icoOk);
  btnAccept->setFixedSize (20, 20);
  btnAccept->setEnabled (write);
  connect (btnAccept, SIGNAL (clicked ()), SLOT (slotAccept ()));
  grid->addWidget (btnAccept, 3, 0, AlignLeft);
  btnReject = new QPushButton (this);
  icoReject = QPixmap (reject_xpm);
  btnReject->setPixmap (icoReject);
  btnReject->setFixedSize (20, 20);
  connect (btnReject, SIGNAL (clicked ()), SLOT (slotReject ()));
  grid->addWidget (btnReject, 3, 2, AlignRight);
}

printprice::~printprice ()
{
}

void
printprice::slotAccept ()
{
  QDialog::accept ();
}

void
printprice::slotReject ()
{
  QDialog::reject ();
}
