/* newuser.cc 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qmessagebox.h>
#include "newuser.hh"
#include "icons/ok.xpm"
#include "icons/reject.xpm"

newuser::newuser (QWidget * parent, const char *name, bool modal):
QDialog (parent, name, modal)
{
  setCaption (tr ("New User"));
  icoAccept = QPixmap (ok_xpm);
  icoReject = QPixmap (reject_xpm);
  lbName = new QLabel (this);
  lbName->setText (tr ("Name"));
  edName = new QLineEdit (this);
  edCountdown = new QCheckBox (this);
  edCountdown->setText (tr ("Countdown"));
  lbTime = new QLabel (this);
  lbTime->setText (tr ("Elapsed Time"));
  edTime = new QTimeEdit (this);
  btnAccept = new QPushButton (this);
  btnAccept->setPixmap (icoAccept);
  btnReject = new QPushButton (this);
  btnReject->setPixmap (icoReject);
  grid = new QGridLayout (this, 4, 2, 5, 3);
  grid->addWidget (lbName, 0, 0);
  grid->addWidget (edName, 0, 1);
  grid->addWidget (edCountdown, 1, 1);
  grid->addWidget (lbTime, 2, 0);
  grid->addWidget (edTime, 2, 1);
  grid->addWidget (btnAccept, 3, 0);
  grid->addWidget (btnReject, 3, 1);
  btnAccept->setDefault (true);
  connect (edCountdown, SIGNAL (toggled (bool)), this,
	   SLOT (slotCounter (bool)));
  connect (btnAccept, SIGNAL (clicked ()), this, SLOT (slotBtnAccept ()));
  connect (btnReject, SIGNAL (clicked ()), this, SLOT (slotBtnReject ()));
}

newuser::~newuser ()
{

}

void
newuser::slotBtnAccept ()
{
  if (edName->text () == "")
    QMessageBox::information (this, tr ("New User"),
			      tr ("Please enter a name for this user"));
  else
    QDialog::accept ();
}

void
newuser::slotBtnReject ()
{
  QDialog::reject ();
}

void
newuser::slotCounter (bool on)
{
  if (on == true)
    lbTime->setText (tr ("Countdown Time"));
  else
    lbTime->setText (tr ("ElapsedTime"));
}
