/* about.cc */
#include "about.hh"
#include "copying.h"

about::about(QWidget *parent, const char *name, bool modal, WFlags f)
  : QDialog(parent, name, modal, f)
{
  appIco = QPixmap(icon_xpm);
  vBox = new QVBoxLayout(this);
  infoBox = new QHBoxLayout(this,3);
  lbIcon = new QLabel(this);
  lbIcon->setPixmap(appIco);
  infoBox->addWidget(lbIcon);
  lbInfo = new QLabel(this);
  lbInfo->setText(QString("Zeiberbude Version %1 (http://zeiberbude.sourceforge.net)") .arg(VERSION));
  infoBox->addWidget(lbInfo);
  vBox->addLayout(infoBox);
  tab = new QTabWidget(this);
  lbAuthors = new QLabel(this);
  lbAuthors->setAlignment(AlignTop);
  lbAuthors->setText(tr("Maintainer:\nChristian Toepp <c.toepp@gmx.de>"));
  lbTranslators = new QLabel(this);
  lbTranslators->setAlignment(AlignTop);
  lbTranslators->setText(
			 tr("German:\nChristian Toepp <c.toepp@gmx.de>\n \n")
			 + tr("English:\nGeorg Stiller <gstiller@users.sourceforge.net>\n \n")
			 );
  lbThx = new QLabel(this);
  lbThx->setAlignment(AlignTop);
  lbThx->setText(tr("Thanks to:\n")
		 + QString("Vasily Popov")
		 );
  lbLicense = new QTextEdit(this);
  lbLicense->setReadOnly(true);
  lbLicense->setAlignment(AlignTop);
  lbLicense->setText(license);
  tab->addTab(lbAuthors,tr("Authors"));
  tab->addTab(lbTranslators,tr("Translators"));
  tab->addTab(lbThx,tr("Thanks"));
  tab->addTab(lbLicense,tr("License"));
  vBox->addWidget(tab);
  btnBox = new QHBoxLayout(this);
  spLeft = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
  btnBox->addItem(spLeft);
  btnOk = new QPushButton(this);
  btnOk->setText("OK");
  connect(btnOk,SIGNAL(clicked()),SLOT(slotBtnOk()));
  btnBox->addWidget(btnOk);
  spRight = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
  btnBox->addItem(spRight);
  vBox->addLayout(btnBox);
}

about::~about()
{
}

void
about::slotBtnOk()
{
  QDialog::accept();
}
