#include <gtk/gtk.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include "port_signal.h"
#include "project.h"
#include "interface.h"
#include "yepplib.h"
#include "ieee1284.h"

#define TRUE 1
#define FALSE 0

struct yepp_dirent *dirp;
struct yepp_status *status;

int row_flash = 0, row_card = 0;
int where = YEPP_WHERE_BASE;
int fd, ch_pid, tag;

int is_busy = FALSE;
int is_connected = FALSE;

GtkWidget *main_window;
GtkWidget *clist1, *clist2;
GtkWidget *statusbar1, *statusbar2;
GtkWidget *button_flash, *button_card;
GtkWidget *progressbar;

void yepp_exit(void)
{
   yepp_release();
   is_connected = FALSE;
   gtk_main_quit();
}

GtkWidget* load_xpm(char *xpm)
{
   GtkWidget *pixmapwid;
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   GtkStyle *style;

   gtk_widget_realize(main_window);
   style = gtk_widget_get_style(main_window);
   pixmap = gdk_pixmap_create_from_xpm(main_window->window,  &mask,
                                        &style->bg[GTK_STATE_NORMAL], xpm);

   pixmapwid = gtk_pixmap_new(pixmap, mask);

   gtk_widget_show(pixmapwid);

   return pixmapwid;
}

void print_status()
{
   char buf[40];

   sprintf(buf, "Size : %dK        Free : %dK", status->flash_size, status->flash_free);
   gtk_entry_set_text(GTK_ENTRY(statusbar1), buf);
   
   sprintf(buf, "Size : %dK        Free : %dK", status->card_size, status->card_free);
      gtk_entry_set_text(GTK_ENTRY(statusbar2), buf);
}


void append_to_list(int loop, char* index_buf, char* size_buf, int where)
{
   char *buf[] = { index_buf, size_buf, "not yet", (dirp+loop)->name };
   if(where == YEPP_WHERE_BASE)
      gtk_clist_append((GtkCList *)clist1, buf);
   else
      gtk_clist_append((GtkCList *)clist2, buf);
}

void print_yepp_dir()
{
   char index_buf[4];
   char size_buf[7];
   int loop, where;

   for(loop = 0; (dirp+loop)->index != FAIL; loop++)
   {
      if((dirp + loop)->index - 130 < 0)
      {
         sprintf(index_buf, "%d", (dirp + loop)->index);
	 where = YEPP_WHERE_BASE;
	 row_flash++;
      }
      else
      {
         sprintf(index_buf, "%d", (dirp + loop)->index - 130);
         where = YEPP_WHERE_CARD;
	 row_card++;
      }
      sprintf(size_buf, "%dKB", (dirp + loop)->size / 1024);
      append_to_list(loop, index_buf, size_buf, where);
   }
}

void clear_yepp_dir()
{
   int loop;

   if(row_flash > 0)
      for(loop = 1; loop <= row_flash; loop++)
         gtk_clist_remove (GTK_CLIST(clist1), 0);
   
   if(row_card > 0)
      for(loop = 1; loop <= row_card; loop++)
         gtk_clist_remove (GTK_CLIST(clist2), 0);
}

void connect_to_yepp()
{
   if(is_busy || is_connected)
      return;

   is_busy = TRUE;
   
   negotiate(0x10);
   yepp_wakeup();
   if(!yepp_ping())
   {
      yepp_release();
      return;
   }

   status = (struct yepp_status*)yepp_connect();
   print_status();

   dirp = (struct yepp_dirent*)yepp_dir();
   print_yepp_dir();

   is_connected = TRUE;
   is_busy = FALSE;
}

void sigusr1_parent(int sig)
{
   signal(SIGUSR1, SIG_IGN);
   kill(ch_pid, SIGSTOP);
   gdk_input_remove(tag);
   close(fd);
   kill(ch_pid, SIGKILL);

   status = (struct yepp_status*)yepp_connect();
   print_status();
   dirp = (struct yepp_dirent*)yepp_dir();
   gtk_clist_clear(GTK_CLIST(clist1));
   gtk_clist_clear(GTK_CLIST(clist2));
   print_yepp_dir();

   is_busy = FALSE;
}

void upload(GtkWidget *button, GtkWidget *file_select)
{
   char *fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_select));

   if(is_busy || !is_connected)
      return;

   is_busy = TRUE;

   if(!yepp_ping())
   {
      yepp_release();
      return;
   }

   fd = mkfifo("/tmp/yepp_fifo", 0660);

   fd = open("/tmp/yepp_fifo", O_RDWR);
   signal(SIGUSR1, sigusr1_parent);
   if(( ch_pid = fork()) == 0)
   {
      signal(SIGUSR1, SIG_IGN);
      upload_to_yepp(fname, where, 1);
      kill(getppid(), SIGUSR1);
      sleep(1000);
   }
   else
   {
      tag = gdk_input_add(fd, GDK_INPUT_READ, progress_bar_update, NULL);
   }
}

void widget_destroy(GtkWidget *button, GtkWidget *file_select)
{
   gtk_widget_destroy(file_select);
}

void file_selection()
{
   GtkWidget *file_select;

   file_select = gtk_file_selection_new("Yepp E-Series & Mpio File Upload");
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_select)->ok_button),
                      "clicked", GTK_SIGNAL_FUNC(upload), file_select); 
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_select)->cancel_button),
                      "clicked", GTK_SIGNAL_FUNC(widget_destroy), file_select);
   
   gtk_widget_show(file_select);
}

void to_card()
{
   where = YEPP_WHERE_CARD;
   file_selection();
//   status = (struct yepp_status*)yepp_connect();
//   print_status();
//   dirp = (struct yepp_dirent*)yepp_dir();
//   gtk_clist_clear(GTK_CLIST(clist1));
//   gtk_clist_clear(GTK_CLIST(clist2));
//   print_yepp_dir();
}

void to_flash()
{
   where = YEPP_WHERE_BASE;
   file_selection();
}

int get_index_from_row(int row)
{
   gchar *text;
   int index;
   
   if( row > 130)
   {
      gtk_clist_get_text(GTK_CLIST(clist2), row - 131, 0, &text);
      index = atoi(text) + 130;
   }
   else
   {
      gtk_clist_get_text(GTK_CLIST(clist1), row, 0, &text);
      index = atoi(text);
   }

   return index;
}

void delete()
{
   int row;
   int index;

   if(is_busy || !is_connected)
      return;

   is_busy = TRUE;
   
   if(((GtkCList*)(clist1))->selection != NULL)
   {
      row =  (int)((GtkCList*)(clist1))->selection->data;
      index = get_index_from_row(row);
      yepp_delete(index);
   }
   
   if(((GtkCList*)(clist2))->selection != NULL)
   {
      row = (int)((GtkCList*)(clist2))->selection->data;
      index = get_index_from_row(row + 131);
      yepp_delete(index);
   }

   status = (struct yepp_status*)yepp_connect();
   print_status();

   dirp = (struct yepp_dirent*)yepp_dir();
   gtk_clist_clear(GTK_CLIST(clist1));
   gtk_clist_clear(GTK_CLIST(clist2));
   print_yepp_dir();

   is_busy = FALSE;
}

void format(GtkWidget *button, int where)
{
   if(is_busy || !is_connected)
      return;

   is_busy = TRUE;
   
   yepp_format(where);
   
   dirp = (struct yepp_dirent*)yepp_dir();
   gtk_clist_clear(GTK_CLIST(clist1));
   gtk_clist_clear(GTK_CLIST(clist2));
   print_yepp_dir();

   status = (struct yepp_status*)yepp_connect();
   print_status();

   is_busy = FALSE;
}

void progress_bar_update(gpointer data, gint source, GdkInputCondition condition)
{
   char cur[4];

   read(fd, &cur, 4);
   gtk_progress_bar_update(GTK_PROGRESS_BAR(progressbar), (float)atoi(cur) / 100);
}

GtkWidget* create_main_window(void)
{
   GtkWidget *main_vbox;
   GtkWidget *menubar;
   GtkWidget *toolbar;
   GtkWidget *tmp_toolbar_icon;
   GtkWidget *button_connect;
   GtkWidget *button_up_to_flash;
   GtkWidget *button_up_to_card;
   GtkWidget *button_down;
   GtkWidget *button_delete;
   GtkWidget *button_format_flash;
   GtkWidget *button_format_card;
   GtkWidget *button_stop;
   GtkWidget *logo_hbox;
   GtkWidget *clist_hbox;
   GtkWidget *scrolledwindow1;
   GtkWidget *label_index1;
   GtkWidget *label_size1;
   GtkWidget *label_time1;
   GtkWidget *label_name1;
   GtkWidget *scrolledwindow2;
   GtkWidget *label_index2;
   GtkWidget *label_size2;
   GtkWidget *label_time2;
   GtkWidget *label_name2;
   GtkWidget *statusbar_hbox;

   main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT(main_window), "destroy", GTK_SIGNAL_FUNC(yepp_exit), NULL);
   gtk_window_set_title(GTK_WINDOW(main_window), "Mpio EX-MP, Yepp E-series & Z-series");

   main_vbox = gtk_vbox_new(FALSE, 0);
   gtk_widget_ref(main_vbox);
   gtk_container_add(GTK_CONTAINER(main_window), main_vbox);
   gtk_widget_show(main_vbox);

   menubar = gtk_menu_bar_new();
   gtk_widget_ref(menubar);
   gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, FALSE, 0);
   
   toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
   gtk_widget_ref(toolbar);
   gtk_box_pack_start (GTK_BOX (main_vbox), toolbar, FALSE, FALSE, 0);
   gtk_widget_show(toolbar);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/connect.xpm");

   button_connect = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                               NULL, "Connect", NULL, NULL,
                                               tmp_toolbar_icon, NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_connect), "clicked",
	              GTK_SIGNAL_FUNC(connect_to_yepp), NULL);
   gtk_widget_ref(button_connect);
   gtk_widget_show(button_connect);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/up_to_flash.xpm");
   
   button_up_to_flash = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
	                                           GTK_TOOLBAR_CHILD_BUTTON, NULL,
                                    "Up to Memory", NULL, NULL, tmp_toolbar_icon, NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_up_to_flash), "clicked", GTK_SIGNAL_FUNC(to_flash),
	              NULL);
   gtk_widget_ref(button_up_to_flash);
   gtk_widget_show(button_up_to_flash);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/up_to_card.xpm");
   
   button_up_to_card = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                                  GTK_TOOLBAR_CHILD_BUTTON, NULL,
                                       "Up to card", NULL, NULL, tmp_toolbar_icon, NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_up_to_card), "clicked", GTK_SIGNAL_FUNC(to_card),
                      NULL);
   gtk_widget_ref (button_up_to_card);
   gtk_widget_show(button_up_to_card);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/down.xpm");

   button_down = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                            NULL, "Down to PC", NULL, NULL,
                                            tmp_toolbar_icon, NULL, NULL);
   gtk_widget_ref(button_down);
   gtk_widget_show(button_down);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/delete.xpm");
   
   button_delete = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                              NULL, "Delete", NULL, NULL, tmp_toolbar_icon,
                                              NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_delete), "clicked", GTK_SIGNAL_FUNC(delete), NULL);
   gtk_widget_ref(button_delete);
   gtk_widget_show(button_delete);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/format.xpm");

   button_format_flash = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
	                                       GTK_TOOLBAR_CHILD_BUTTON, NULL,
                                               "Format Memory", NULL, NULL,
                                               tmp_toolbar_icon, NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_format_flash), "clicked", GTK_SIGNAL_FUNC(format), (gpointer)YEPP_WHERE_BASE);
   gtk_widget_ref (button_format_flash);
   gtk_widget_show(button_format_flash);

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/format.xpm");

   button_format_card = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
	                                            GTK_TOOLBAR_CHILD_BUTTON, NULL,
                                                    "Format Card", NULL, NULL,
                                                    tmp_toolbar_icon, NULL, NULL);
   gtk_signal_connect(GTK_OBJECT(button_format_card), "clicked", GTK_SIGNAL_FUNC(format), (gpointer)YEPP_WHERE_CARD);
   gtk_widget_ref (button_format_card);
   gtk_widget_show(button_format_card);
	    

   tmp_toolbar_icon = load_xpm("/usr/share/icons/mini/stop.xpm");

   button_stop = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_CHILD_BUTTON,
                                            NULL, "Stop", NULL, NULL, tmp_toolbar_icon,
                                            NULL, NULL);
   gtk_widget_ref(button_stop);
   gtk_widget_show(button_stop);

   logo_hbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_vbox), logo_hbox, TRUE, TRUE, 0);
   gtk_widget_ref(logo_hbox);
   gtk_widget_show(logo_hbox);

   button_flash = gtk_button_new_with_label("Flash Memory");
   gtk_box_pack_start(GTK_BOX(logo_hbox), button_flash, TRUE, TRUE, 0);
   gtk_widget_show(button_flash);
   
   button_card = gtk_button_new_with_label("Smart Media Card");
   gtk_box_pack_start(GTK_BOX(logo_hbox), button_card, TRUE, TRUE, 0);
   gtk_widget_show(button_card);

   clist_hbox = gtk_hbox_new(FALSE, 0);
   gtk_widget_ref(clist_hbox);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "hbox1", clist_hbox,
	                    (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(clist_hbox);
   gtk_box_pack_start(GTK_BOX (main_vbox), clist_hbox, TRUE, TRUE, 0);

   scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
   gtk_widget_ref(scrolledwindow1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(scrolledwindow1);
   gtk_box_pack_start(GTK_BOX(clist_hbox), scrolledwindow1, TRUE, TRUE, 0);

   clist1 = gtk_clist_new(4);
   gtk_widget_ref(clist1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "clist1", clist1,
	                    (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(clist1);
   gtk_container_add(GTK_CONTAINER(scrolledwindow1), clist1);
   gtk_widget_set_usize(clist1, 300, 250);
   gtk_clist_set_column_width(GTK_CLIST(clist1), 0, 33);
   gtk_clist_set_column_width(GTK_CLIST(clist1), 1, 49);
   gtk_clist_set_column_width(GTK_CLIST(clist1), 2, 65);
   gtk_clist_set_column_width(GTK_CLIST(clist1), 3, 80);
   gtk_clist_column_titles_show(GTK_CLIST(clist1));

   label_index1 = gtk_label_new("Index");
   gtk_widget_ref(label_index1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Index", label_index1,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_index1);
   gtk_clist_set_column_widget (GTK_CLIST(clist1), 0, label_index1);

   label_size1 = gtk_label_new("Size");
   gtk_widget_ref(label_size1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Size", label_size1,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_size1);
   gtk_clist_set_column_widget(GTK_CLIST(clist1), 1, label_size1);

   label_time1 = gtk_label_new("Time");
   gtk_widget_ref (label_time1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Time", label_time1,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_time1);
   gtk_clist_set_column_widget (GTK_CLIST(clist1), 2, label_time1);

   label_name1 = gtk_label_new("Name");
   gtk_widget_ref(label_name1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Name", label_name1,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_name1);
   gtk_clist_set_column_widget(GTK_CLIST(clist1), 3, label_name1);

   scrolledwindow2 = gtk_scrolled_window_new(NULL, NULL);
   gtk_widget_ref(scrolledwindow2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(scrolledwindow2);
   gtk_box_pack_start(GTK_BOX(clist_hbox), scrolledwindow2, TRUE, TRUE, 0);

   clist2 = gtk_clist_new(4);
   gtk_widget_ref(clist2);
   gtk_object_set_data_full (GTK_OBJECT(main_window), "clist2", clist2,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(clist2);
   gtk_container_add (GTK_CONTAINER(scrolledwindow2), clist2);
   gtk_widget_set_usize (clist2, 300, 250);
   gtk_clist_set_column_width(GTK_CLIST(clist2), 0, 33);
   gtk_clist_set_column_width(GTK_CLIST(clist2), 1, 49);
   gtk_clist_set_column_width(GTK_CLIST(clist2), 2, 65);
   gtk_clist_set_column_width(GTK_CLIST(clist2), 3, 80);
   gtk_clist_column_titles_show(GTK_CLIST(clist2));

   label_index2 = gtk_label_new ("Index");
   gtk_widget_ref(label_index2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Index", label_index2,
                             (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show (label_index2);
   gtk_clist_set_column_widget(GTK_CLIST (clist2), 0, label_index2);

   label_size2 = gtk_label_new ("Size");
   gtk_widget_ref(label_size2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Size", label_size2,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_size2);
   gtk_clist_set_column_widget(GTK_CLIST(clist2), 1, label_size2);

   label_time2 = gtk_label_new ("Time");
   gtk_widget_ref(label_time2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Time", label_time2,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_time2);
   gtk_clist_set_column_widget(GTK_CLIST(clist2), 2, label_time2);

   label_name2 = gtk_label_new("Name");
   gtk_widget_ref(label_name2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "Name", label_name2,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(label_name2);
   gtk_clist_set_column_widget(GTK_CLIST(clist2), 3, label_name2);

   progressbar = gtk_progress_bar_new();
   gtk_widget_ref(progressbar);
   gtk_object_set_data_full (GTK_OBJECT (main_window), "progressbar", progressbar,
                             (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(progressbar);
   gtk_box_pack_start (GTK_BOX (main_vbox), progressbar, FALSE, FALSE, 0);

   statusbar_hbox = gtk_hbox_new(FALSE, 0);
   gtk_widget_ref(statusbar_hbox);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "statusbar_hbox", statusbar_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(statusbar_hbox);
   gtk_box_pack_start(GTK_BOX(main_vbox), statusbar_hbox, TRUE, TRUE, 0);

   statusbar1 = gtk_entry_new();
   gtk_widget_ref(statusbar1);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "statusbar1", statusbar1,
                           (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show (statusbar1);
   gtk_box_pack_start (GTK_BOX(statusbar_hbox), statusbar1, TRUE, TRUE, 0);
   gtk_widget_set_usize (statusbar1, -2, 30);
	    
   statusbar2 = gtk_entry_new();
   gtk_widget_ref(statusbar2);
   gtk_object_set_data_full(GTK_OBJECT(main_window), "statusbar2", statusbar2,
                           (GtkDestroyNotify) gtk_widget_unref);
   gtk_widget_show(statusbar2);
   gtk_box_pack_start (GTK_BOX(statusbar_hbox), statusbar2, TRUE, TRUE, 0);
   gtk_widget_set_usize (statusbar2, -2, 30);

   return main_window;
}
