#ifndef __YEPP_LIB_H
#define __YEPP_LIB_H
#endif

#ifdef __YEPP_LIB_H

extern float cur_block, blocks;
extern int fd;

struct yepp_status
{
   int flash_size;
   int flash_free;

   int card_size;
   int card_free;
};

struct yepp_dirent
{
   int index;
   int type;
   int size;
   char name[515];
   int attr;
};

extern int yepp_ping(void);
extern int yepp_wakeup(void);
extern struct yepp_status*  yepp_status(void);
extern void yepp_release(void);
extern struct yepp_status* yepp_connect(void);
extern struct yepp_dirent* yepp_dir(void);
extern int yepp_send_dword (int);
extern int yepp_send_word (int);
extern int yepp_bytes_to_blocks (int);
extern int upload_to_yepp(char*, int, int);
extern int yepp_delete(int);
extern int yepp_format(int);

#define YEPP_TYPE_DATA  0x00
#define YEPP_TYPE_MP3   0x01
#define YEPP_TYPE_TEL   0x02
#define YEPP_TYPE_SC4   0x03
#define YEPP_TYPE_RESV  0x04

#define YEPP_WHERE_BASE  0x0
#define YEPP_WHERE_CARD  0x1

#define YEPP_ORDER_LEN 252

#define YEPP_SERIAL_INDEX 0x1
#define YEPP_CONFIG_INDEX 0x2
#define YEPP_ENCODE_INDEX 0x3
#define YEPP_DECODE_INDEX 0x4

#endif /* __YEPP_LIB_H__ */
