#ifndef __BLENDERSHADER_H
#define __BLENDERSHADER_H

#include "metashader.h"
#include "params.h"

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

__BEGIN_YAFRAY

#ifndef TEX_PROJ0 //Removed from modulator

enum TEX_MAPTYPE {TXM_FLAT, TXM_CUBE, TXM_TUBE, TXM_SPHERE};
enum TEX_COORDS {TXC_UV, TXC_GLOB, TXC_ORCO, TXC_WIN, TXC_NOR, TXC_REFL};
enum TEX_CLIPMODE {TCL_EXTEND, TCL_CLIP, TCL_CLIPCUBE, TCL_REPEAT};

// projection
#define TEX_PROJ0 0
#define TEX_PROJX 1
#define TEX_PROJY 2
#define TEX_PROJZ 3

// texture flag
#define TXF_RGBTOINT	1
#define TXF_STENCIL		2
#define TXF_NEGATIVE	4

#endif

class blenderMapperNode_t : public shaderNode_t
{
	public:
		blenderMapperNode_t(const shader_t *m);
		virtual ~blenderMapperNode_t() {};

		virtual CFLOAT stdoutFloat(renderState_t &state,const surfacePoint_t &sp, const vector3d_t &eye,
				const scene_t *scene=NULL) const;
		virtual colorA_t stdoutColor(renderState_t &state,const surfacePoint_t &sp, const vector3d_t &eye,
				const scene_t *scene=NULL) const;
		virtual bool discrete()const {return mapped->discrete();};
		virtual bool isRGB() const { return mapped->isRGB(); }
		static shader_t * factory(paramMap_t &,std::list<paramMap_t> &,
				        renderEnvironment_t &);


	protected:

		bool doMapping(const surfacePoint_t &sp, const vector3d_t &eye,point3d_t &texpt) const;
		// size factors
		void sizeX(GFLOAT c) { _sizex=c; }
		void sizeY(GFLOAT c) { _sizey=c; }
		void sizeZ(GFLOAT c) { _sizez=c; }
		void size(GFLOAT c) { _sizex=_sizey=_sizez=c; }

		// offset
		void ofsX(GFLOAT c) { _ofsx=c; }
		void ofsY(GFLOAT c) { _ofsy=c; }
		void ofsZ(GFLOAT c) { _ofsz=c; }

		// matrix
		void setTransform(const matrix4x4_t &M) { tex_Mtx=M;  has_transform=true; }

		// crop
		void setCrop(GFLOAT minx, GFLOAT miny, GFLOAT maxx, GFLOAT maxy)
		{ _cropminx=minx;  _cropminy=miny;  _cropmaxx=maxx;  _cropmaxy=maxy; }

		// repeat
		void setRepeat(int x, int y) { _xrepeat=x;  _yrepeat=y; }

		void string2maptype(const std::string &mapname);

		void string2texcotype(const std::string &texconame);

		void string2cliptype(const std::string &clipname);
		void string2texprojection(const std::string &x_axis, const std::string &y_axis, const std::string &z_axis);

		void setRot90(bool r90) { _rot90=r90; }
		const shader_t *mapped;
		GFLOAT _sizex, _sizey, _sizez;	// texture scale factors
		int _mode;
		TEX_MAPTYPE tex_maptype;								// image texture mapping mode
		TEX_COORDS tex_coords;									// type of texture coords used for the mapping
		bool has_transform;
		matrix4x4_t tex_Mtx;										// texture transform matrix
		GFLOAT _ofsx, _ofsy, _ofsz;							// texture offset factors
		GFLOAT _cropminx, _cropminy,
					 _cropmaxx, _cropmaxy;						// image texture crop factors, range [0, 1]
		int _xrepeat, _yrepeat;									// image texture repeat factors
		TEX_CLIPMODE	tex_clipmode;							// image texture clipping mode
		char tex_projx, tex_projy, tex_projz;		// texture projection axes
		bool _rot90;
};

// alpha flag
#define TXA_CALCALPHA	1
#define TXA_USEALPHA	2
#define TXA_NEGALPHA	4

class blenderModulator_t : public modulator_t
{
	public :
		blenderModulator_t(const shader_t *sh):modulator_t(NULL)
		{
			input = sh;
			texflag = 0;
			texture_col = color_t(0.0);
			_csp = _cmir = _ref = _alpha = _emit = 0;
			_contrast = _brightness = 1.0;
			alpha_flag = 0;
		};
		~blenderModulator_t() {};

		void colspec(int cs) { _csp=cs; }
		int colspec() { return _csp; }
		void cmir(int cm) { _cmir=cm; }
		int cmir() { return _cmir; }
		void difref(int dr) { _ref=dr; }
		int difref() { return _ref; }
		void alpha(int al) { _alpha=al; }
		int alpha() { return _alpha; }
		void emit(int em) { _emit=em; }
		int emit() { return _emit; }

		void blenderDisplace(renderState_t &state,surfacePoint_t &sp,
									const vector3d_t &eye, PFLOAT res) const;
		void modulate(colorA_t &T,colorA_t &R,renderState_t &state,
				const surfacePoint_t &sp,const vector3d_t &eye) const;
		void blenderModulate(colorA_t &col, colorA_t &colspec,
					colorA_t &refcol, colorA_t &colmir,CFLOAT &refcol0, CFLOAT &ref,
					CFLOAT &spec, CFLOAT &har, CFLOAT &emit, CFLOAT &alpha,
					CFLOAT &stencilTin,	renderState_t &state,const surfacePoint_t &sp,
					const vector3d_t &eye) const;
		void blenderModulate(colorA_t &col, CFLOAT &ref, CFLOAT &emit,CFLOAT &alpha,
				CFLOAT &stencilTin, renderState_t &state,const surfacePoint_t &sp,	
				const vector3d_t &eye) const;

		void setColFac(CFLOAT cf) { colfac = cf; }
		void setDVar(CFLOAT dv) { def_var = dv; }
		void setVarFac(CFLOAT vf) { varfac = vf; }
		void setTexFlag(const std::string &st)
		{
			// string can contain multiple 'flags'
			if (int(st.find("stencil"))!=-1) texflag |= TXF_STENCIL;
			if (int(st.find("negative"))!=-1) texflag |= TXF_NEGATIVE;
			if (int(st.find("no_rgb"))!=-1) texflag |= TXF_RGBTOINT;
		}
		void setTexCol(const color_t &tc) { texture_col = tc; }

		void setFilterCol(const color_t &fc) { _filtercolor = fc; }
		void setContrast(CFLOAT c) { _contrast = c; }
		void setBrightness(CFLOAT b) { _brightness = b; }
		void setAlphaFlag(const std::string &st)
		{
			if (int(st.find("calc_alpha"))!=-1) alpha_flag |= TXA_CALCALPHA;
			if (int(st.find("use_alpha"))!=-1) alpha_flag |= TXA_USEALPHA;
			if (int(st.find("neg_alpha"))!=-1) alpha_flag |= TXA_NEGALPHA;
		}

	protected:

		const shader_t *input;
		// blender modulation
		unsigned char texflag;	//bitmask
		CFLOAT colfac, def_var, varfac;
		colorA_t texture_col;
		char _csp, _cmir, _ref, _alpha, _emit;
		// texture brightness, contrast & color adjustment
		colorA_t _filtercolor;
		CFLOAT _contrast, _brightness;
		char alpha_flag;
};

// material modes
#define MAT_TRACEABLE		1
#define MAT_SHADOW			2
#define MAT_SHADELESS		4
#define MAT_VCOL_LIGHT	8
#define MAT_VCOL_PAINT	16
#define MAT_ZTRANSP			32
#define MAT_ONLYSHADOW	64

// the blendershader
class blenderShader_t : public shader_t
{
	public:

		blenderShader_t(const color_t &color, const color_t &spc, const color_t &mirc,
										CFLOAT dr, CFLOAT spam, CFLOAT h, CFLOAT al, CFLOAT em,
										const color_t &er, const color_t &erfr, const color_t &er2, const color_t &erfr2,
										CFLOAT minr=0, PFLOAT _IOR=1.5,
										bool fastf=false,bool _tir=false)
		{
			scolor = color;
			speccol = spc;
			mircol = mirc;
			edif = dr;
			specam = spam;
			hard = h;
			alpha = al;
			emit = em;
			eref = er;
			erefr = erfr;
			minR = minr;
			IOR = _IOR;
			// for fast_fresnel()
			fastf_IOR = (IOR - 1.0) / (IOR + 1.0);
			fastf_IOR *= fastf_IOR;
			mat_mode=0;
			use_fastf = fastf;
			tir=_tir;
			// for use with fresnel color modulation
			eref2=er2;  erefr2=erfr2;
		};
		virtual color_t fromRadiosity(renderState_t &state, const surfacePoint_t &sp, const energy_t &ene,
															const vector3d_t &eye) const;
		virtual color_t fromLight(renderState_t &state, const surfacePoint_t &sp, const energy_t &energy,
															const vector3d_t &eye) const;
		virtual color_t fromWorld(renderState_t &state, const surfacePoint_t &sp, const scene_t &scene,
															const vector3d_t &eye) const;
		virtual const color_t getDiffuse(renderState_t &state,
									const surfacePoint_t &sp, const vector3d_t &eye) const;
		virtual ~blenderShader_t() {}

		virtual void displace(renderState_t &state,surfacePoint_t &sp,
				const vector3d_t &eye, PFLOAT res) const;

		void addModulator(const blenderModulator_t &mod) { mods.push_back(mod); }

		void setMode(const std::string &mst)
		{
			if (int(mst.find("traceable"))!=-1) mat_mode |= MAT_TRACEABLE;
			if (int(mst.find("shadow"))!=-1) mat_mode |= MAT_SHADOW;
			if (int(mst.find("shadeless"))!=-1) mat_mode |= MAT_SHADELESS;
			if (int(mst.find("vcol_light"))!=-1) mat_mode |= MAT_VCOL_LIGHT;
			if (int(mst.find("vcol_paint"))!=-1) mat_mode |= MAT_VCOL_PAINT;
			if (int(mst.find("ztransp"))!=-1) mat_mode |= MAT_ZTRANSP;
			if (int(mst.find("onlyshadow"))!=-1) mat_mode |= MAT_ONLYSHADOW;
		}

		static shader_t * factory(paramMap_t &,std::list<paramMap_t> &,
				        renderEnvironment_t &);

	protected:
		/// surface diffuse/specular/mirror(blender, not reflection) color
		colorA_t scolor, speccol, mircol;
		/// diffuse/specular reflection amount
		CFLOAT edif, specam;
		/// alpha and emit amount
		CFLOAT alpha, emit;
		/// reflected and transmitted colors
		colorA_t eref, erefr;
		// for use with fresnel factor
		colorA_t eref2, erefr2;
		/// hardness, minimum reflection
		CFLOAT hard, minR;
		/// index of refraction.
		PFLOAT IOR;
		/// IOR precalculated for fast fresnel function
		PFLOAT fastf_IOR;
		bool use_fastf,tir;
		/// The sequence of modulators
		std::vector<blenderModulator_t> mods;
		// Blender material modes
		unsigned short mat_mode;
};

__END_YAFRAY

#endif
