/****************************************************************************
 *
 * 			texture.h: Texture and modulation api
 *      This is part of the yafray package
 *      Copyright (C) 2002 Alejandro Conty Estevez
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#ifndef __BASICTEX_H
#define __BASICTEX_H

#include "texture.h"
#include "targaIO.h"
#include "params.h"

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif


__BEGIN_YAFRAY

class textureClouds_t : public texture_t
{
	public:
		textureClouds_t(int dep, const color_t &c1, const color_t &c2)
			:depth(dep), color1(c1), color2(c2) {};
		virtual ~textureClouds_t() {};

		virtual colorA_t getColor(const point3d_t &p) const;
		virtual CFLOAT getFloat(const point3d_t &p) const;

		static texture_t *factory(paramMap_t &params,renderEnvironment_t &render);
	protected:
		int depth;
		color_t color1, color2;
		newPerlin_t noiseGen;
};


class textureMarble_t : public texture_t
{
	public:
		textureMarble_t(int oct, const color_t &c1, const color_t &c2,
					CFLOAT turb, CFLOAT shp, bool hrd)
			:octaves(oct), color1(c1), color2(c2),
			turbulence(turb), hard(hrd)
		{
			sharpness = 1.0;
			if (shp>1) sharpness = 1.0/shp;
		}
		virtual ~textureMarble_t() {};

		virtual colorA_t getColor(const point3d_t &p) const;
		virtual CFLOAT getFloat(const point3d_t &p) const;

		static texture_t *factory(paramMap_t &params,renderEnvironment_t &render);
	protected:
		int octaves;
		color_t color1, color2;
		CFLOAT turbulence, sharpness;
		bool hard;
		newPerlin_t noiseGen;
};


class textureWood_t : public texture_t
{
	public:
		textureWood_t(int oct, const color_t &c1, const color_t &c2,
				CFLOAT turb, PFLOAT rx, PFLOAT ry, bool hrd)
			:octaves(oct), color1(c1), color2(c2),
			turbulence(turb), ringscale_X(rx), ringscale_Y(ry),
			hard(hrd) {};
		virtual ~textureWood_t() {};

		virtual colorA_t getColor(const point3d_t &p) const;
		virtual CFLOAT getFloat(const point3d_t &p) const;

		static texture_t *factory(paramMap_t &params,renderEnvironment_t &render);
	protected:
		int octaves;
		color_t color1, color2;
		CFLOAT turbulence;
		PFLOAT ringscale_X, ringscale_Y;
		bool hard;
		newPerlin_t noiseGen;
};

class textureImage_t : public texture_t
{
	public:
		textureImage_t(const char *filename);
		virtual ~textureImage_t();

		virtual colorA_t getColor(const point3d_t &sp) const;
		virtual CFLOAT getFloat(const point3d_t &p) const ;

		virtual bool loadFailed() const { return failed; }
		virtual bool discrete() { return true; }
		virtual GFLOAT toPixelU(GFLOAT u)
		{
			if (failed) return 0.0;
			return u*(GFLOAT)image->resx();
		}
		virtual GFLOAT toPixelV(GFLOAT v)
		{
			if (failed) return 0.0;
			return v*(GFLOAT)image->resy();
		}
		static texture_t *factory(paramMap_t &params,renderEnvironment_t &render);
	protected:
		cBuffer_t *image;
		targaImg_t *tga_img;	//have to change this
		bool failed;
};


__END_YAFRAY
#endif
