/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void write_history __P((char *));

__END_DECLS

void write_history(char *object)
{
  FILE *fp;
  char *path;
  char buffer[BUFSIZE];
  char temp[BUFSIZE];
  char *item;
  int cmp_flag=0;
  int len;

#ifdef DEBUG
  fprintf(stderr, "*** write_history() *** history object size: %d\n", strlen(object));
  fprintf(stderr, "*** write_history() *** history object string: \"%s\"\n", object);
#endif /* DEBUG */

  /*
   * Dont add empty lines, spaces to the object history.
   */

  if ((object[0]=='\0')||(object[0]=='\n')||(object[0]==' ')||(object[0]=='\r'))
    {
      return;
    }

  /*
   * Buffer overflow checking for $HOME unnessary.
   */
  len = strlen(getenv("HOME"));
  path = malloc(len+strlen(HISTFILE)+1);
  sprintf(path,"%s%s",getenv("HOME"),HISTFILE);

  /*
   * Check if the object already are in the history file.
   */

  if ((fp=fopen(path,"r")))
    {
      while (fgets(buffer,BUFSIZE-1,fp))
	{
	  sscanf(buffer,"%s",temp);
	  if (!(strcmp(temp, object)))
	    {
	      cmp_flag=1;
	    }
	}
      fclose(fp);
    }

  /*
   * If not in history file, add object and server.
   */

  if (cmp_flag == 0)
    {
      /*
       * Open history file and append object and server.
       */

      if (!(fp=fopen(path,"a")))
	{
	  perror("fopen");
	  exit(0);
	}
      fprintf(fp, "%s # %s\n", object, server);
      fclose(fp);

      /*
       * Reread the history from file and add it to the GList.
       */

      if (!(fp=fopen(path,"r")))
	{
	  perror("fopen");
	  exit(0);
	}
      history_list = NULL;
      while (fgets(buffer,BUFSIZE-1,fp))
	{
	  item = g_malloc(strlen(buffer)+1);
	  sscanf(buffer, "%s", item);
#ifdef DEBUG
	  printf("history flush [item]: %s\n", item);
	  printf("history flush [serv]: %s\n", server);
#endif /* DEBUG */
	  /*	  history_list = g_list_insert_sorted(history_list, item,
		  (GCompareFunc)strcmp); */
	  history_list = g_list_insert(history_list, item, 0);
	}
      fclose(fp);
      free(path);
      gtk_combo_set_popdown_strings (history_combo, history_list);
      gtk_widget_show (GTK_WIDGET(history_combo));

      /*
      item = g_malloc(strlen(object)+1);
      strcpy(item, object);
      snprintf(item,strlen(object)+1,object);
      history_list = g_list_insert_sorted(history_list, item, (GCompareFunc)strcmp);
      gtk_combo_set_popdown_strings (history_combo, history_list);
      gtk_widget_show (GTK_WIDGET(history_combo));
      */
    }
}
