// $Id: Calendar.hh,v 1.1 2002/04/29 15:10:15 flaterco Exp $
/*  Calendar  Manage construction, organization, and printing of calendars.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Calendar {
public:
  Calendar (Station *station, Timestamp start_tm, Timestamp end_tm);
  ~Calendar ();

  void print (Dstr &text_out, int html_form, int oldcal);

  struct blurb {
    Timestamp t_out;
    Station::EventType etype_out;
    Dstr etype_desc;
    PredictionValue pv_out;
    struct blurb *next;
  };

  struct day {
    Timestamp start;
    struct blurb *blurbs;
    struct day *next;
  };

  // You can even have two sunsets in one day:
  //
  // Isla Neny, Antarctica
  // 68.2000 S, 67.0000 W
  //
  // 2001-01-24 12:03 AM ARST   Sunset
  // 2001-01-24  3:17 AM ARST   Sunrise
  // 2001-01-24 11:57 PM ARST   Sunset

protected:

  Dstr timezone;
  Settings *settings;
  Timestamp start_day_start, end_day_start;
  int isCurrent;

  // A hash table is used to get around the ubiquitous problem of
  // subordinate stations returning tide events out of order.

  Calendar::day *hash[calhashsize];
  void add_blurb (struct blurb *b);
  void add_blurb (struct blurb *b, struct day *destination);
  Calendar::day *lookup_day (Timestamp start); // Ret. NULL if needs add
  Calendar::day *add_day (Timestamp start);

  void add_month_banner (Dstr &text_out, Timestamp t, int html_form);
  void Calendar::flush_buf (Dstr &text_out, Dstr *buf, int buflen,
			    int html_form, int oldcal, int headers=0);
};
