/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIXERDIALOG_H
#define MIXERDIALOG_H

#include "wrapper/emucfg.h"  // where we take constants from

#include "MixerDialogData.h"
#include "MixerConfig.h"
#include "GlobalIcon.h"
#include "widgets/LEDButton.h"

const int _voices = 4;
const int _effects = 3;

class MixerDialog : public MixerDialogData
{
    Q_OBJECT

public:

    static const int voices;   // not used outside though :(  )
    static const int effects;  //
    
    MixerDialog(QWidget* parent = 0, const char* name = 0);
    ~MixerDialog();

    void setConfig(const MixerConfig&);
    const MixerConfig& getConfig() const;

 signals:
    
    void changed(const MixerConfig&);
    
 protected slots:

    void setMixerOff();
    void setHighQuality();
    void setFullPanning();
    
    void setEffectsOff();
    void setStereoSurround();
    void setCenteredPanning();

    void setVoice1Volume(int);
    void setVoice2Volume(int);
    void setVoice3Volume(int);
    void setVoice4Volume(int);
    void setVoice1Pan(int);
    void setVoice2Pan(int);
    void setVoice3Pan(int);
    void setVoice4Pan(int);
    void muteVoice1(bool);
    void muteVoice2(bool);
    void muteVoice3(bool);
    void muteVoice4(bool);
    void soloVoice1(bool);
    void soloVoice2(bool);
    void soloVoice3(bool);
    void soloVoice4(bool);

 private:

    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();
        
    MixerConfig config;
    
    QSlider* volSliders[_voices];
    QSlider* panSliders[_voices];
    QPushButton* muteButtons[_voices];
    QPushButton* soloButtons[_voices];
    QWidget* effectWidgets[_effects];

    bool dontTouchMuteButtons;
    int soloIsVoice;  // voice [1..voices] that is SOLO, else (-1)

    void enableVolumeControl(bool);
    void enableEffects(bool);
    void enablePanning(bool);
    
    void setMixerButtons(bool,bool,bool);
    void setEffectButtons(bool,bool,bool);
    
    void setButtons();
    void adjustMuteButtons();
    void adjustPanningSliders();
    
    void currentSoloButtonOff();
    void allMuteSoloButtonsOff();
    
    void muteVoice(int voice, bool val);
    void unMuteAllVoices();

    void newVoiceGain(int voice, int val);
    void newVoicePanPos(int voice, int leftLevel);
};

#endif  /* MixerDialog_h */
