#!/bin/ksh

# Set search path for commands
export PATH=/usr/xpg4/bin:/usr/sbin:/usr/bin:/bin:/sbin

set -x
set -e

#XPRINTDIR=/usr/openwin/server/etc/XpConfig/
#XBINDIR=/usr/openwin/bin

PKG_NAME="mozilla_xprint_xpi"

PKG_FILES="/tmp/tmp_${PKG_NAME}"


if [ "${XPRINTDIR}" = "" ] ; then
    echo "$0: Error: XPRINTDIR not set"
    exit 1
fi

if [ "${XBINDIR}" = "" ] ; then
    echo "$0: Error: XBINDIR not set"
    exit 1
fi
 

# Do not edit
# REL_* vars are paths relative to '/'
# Thanks to the "wonders" of some /bin/sh I cannot use ...
# REL_XPRINTDIR=${XPRINTDIR#*/}
# REL_XBINDIR=${XBINDIR#*/}
# ... ;-(
REL_XPRINTDIR="`echo ${XPRINTDIR} | sed 's/\///'`"
REL_XBINDIR="`echo ${XBINDIR} | sed 's/\///'`"


#### Main

# Create and test tarball of files which should be in the final RPM...
if true ; then
echo "###### Fetching files from build dir..."
(
  # Go to xc/packager/tarball
  cd ../tarball
  # ${XPDESTTARFILE} is used by "make make_xprint_tarball"
  export XPDESTTARFILE="/tmp/xprint_pkg_`date +%y%m%d%H%M%S`.tar.gz"
  make make_xprint_tarball

  # Check if the temp. tarball was being build
  if [ ! -f "${XPDESTTARFILE}" ] ; then
      echo "# temp. tarball missing."
      exit 1
  fi

  # ... and then unpack the temp. tarball in the ${PKG_FILES} dir
  [ -d "${PKG_FILES}" ] && rm -Rf "${PKG_FILES}"
  mkdir "${PKG_FILES}"
  cd "${PKG_FILES}"
  gunzip -c ${XPDESTTARFILE} | tar -xf -
  rm -f ${XPDESTTARFILE}
  
  cd xprint/install
   
  # Remove old ReadMe
  rm -f ${REL_XPRINTDIR}/README
  # Remove docs we do not need in the XPI
  rm -Rf usr/X11R6/man
)
fi

echo "###### Building pkgproto file..."


# Make sure we pick the right binary - users may share one profile
# between different architectures
uname_os="`uname -s`"
uname_cpu="`uname -p 2>/dev/null`" # uname -p may fail on old Debian
if [ "${uname_cpu}" = "unknown" -o "${uname_cpu}" = "" ] ; then
    uname_cpu="`uname -m`"
fi

XPIDIR="${PKG_FILES}/xpi"
echo "XPIDIR=${XPIDIR}."

mkdir -p "${XPIDIR}/xprint_xpi"
mkdir -p "${XPIDIR}/xprint_xpi/${uname_os}_${uname_cpu}"
(
  cd "${XPIDIR}/xprint_xpi"
  # FixME: Need softlinks for all compatible |uname_cpu| types
  case "${uname_cpu}" in
      "i386" | "i486" | "i586" | "i686" | "x86_64" | "athlon" | "Athlon")
          [ ! -d "${uname_os}_i386"   ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_i386"
          [ ! -d "${uname_os}_i486"   ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_i486"
          [ ! -d "${uname_os}_i586"   ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_i586"
          [ ! -d "${uname_os}_i686"   ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_i686"
          [ ! -d "${uname_os}_x86_64" ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_x86_64"
          [ ! -d "${uname_os}_athlon" ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_athlon"
          [ ! -d "${uname_os}_Athlon" ] && ln -s "${uname_os}_${uname_cpu}" "${uname_os}_Athlon"
          ;;
  esac    
)
mkdir -p "${XPIDIR}/init.d"
mv "${PKG_FILES}/xprint"/* "${XPIDIR}/xprint_xpi/${uname_os}_${uname_cpu}/."
cp "K98xprint_xpi.sh" "${XPIDIR}/init.d/."
cp "S98xprint_xpi.sh" "${XPIDIR}/init.d/."
chmod a+rx "${XPIDIR}/init.d"/*.sh
cp "install.js" "${XPIDIR}/."

echo "###### Making package..."

echo "#### zip..."
(
  OLDPWD="${PWD}"
  cd "${XPIDIR}"
  zip -r -y -9 "${OLDPWD}/${PKG_NAME}.xpi" .
)

#echo "###### Cleaning up..."
rm -rf "${PKG_FILES}"

echo "###### Package done:"
ls -lad "${PKG_NAME}.xpi"

echo "###### Done."
exit 0
#
