/* winutils.c - xpm2wico - .xpm to Windows .ico format converter
 *
 * Copyright (C) 2002 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include "winutils.h"

#ifdef DEBUG
int rcounter = 0;
int wcounter = 0;
#endif

Byte read_byte (FILE *file)
{
  Byte ret_byte;
  
  fread (&ret_byte, sizeof (Byte), 1, file);

#ifdef DEBUG
  printf ("Reading one byte ('%d':'%c') at position %d\n",
	  ret_byte, ret_byte, rcounter);
  rcounter += sizeof (Byte);
#endif

  return ret_byte;
}

Word read_word (FILE *file)
{
  Word ret_word;

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
  fread (&ret_word, 1, sizeof (Word), file);
#else
  int i = 0;

  while (i < sizeof (Word)) {
    fread (&ret_word, 1, sizeof (Byte), file);
    ret_word >>= 8;
    i++;
  }
#endif

#ifdef DEBUG
  printf ("Reading one word (%d:'%c','%c') at position %d\n",
	  ret_word, (ret_word / 256), (ret_word % 256), rcounter);
  rcounter += sizeof (Word);
#endif
  

  return (ret_word);
}

DWord read_dword (FILE *file)
{
  DWord ret_dword;

#ifdef DEBUG
  printf ("Reading one dword at position %d\n", rcounter);
  rcounter += sizeof (DWord);
#endif
  
#if (__BYTE_ORDER == __LITTLE_ENDIAN)
  fread (&ret_dword, 1, sizeof (DWord), file);
#else
  int i = 0;

  while (i < sizeof (DWord)) {
    fread (&ret_dword, 1, sizeof (Byte), file);
    ret_dword >>= 8;
    i++;
  }
#endif

  return ret_dword;
}

void
write_byte (FILE *file, Byte byte)
{
#ifdef DEBUG
  printf ("Writing one byte (%d:'%c') at position %d\n", byte, byte, wcounter);
  wcounter += sizeof (Byte);
#endif

  fwrite (&byte, sizeof (Byte), 1, file);
}

void
write_word (FILE *file, Word word)
{
#ifdef DEBUG
  printf ("Writing one word ('%c%c') at position %d\n",
	  (word / 256), (word % 256), wcounter);
  wcounter += sizeof (Word);
#endif

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
   fwrite (&word, sizeof (Word), 1, file);
#else
  int i = 0;

  while (i < sizeof (Word)) {
    fputc (word & 0xff, file);
    word >>= 8;
    i++;
  }
#endif
}

void
write_dword (FILE *file, DWord dword)
{
#ifdef DEBUG
  printf ("Writing one dword at position %d\n", wcounter);
  wcounter += sizeof (DWord);
#endif

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
  fwrite (&dword, sizeof (DWord), 1, file);
#else
  int i = 0;

  while (i < sizeof (DWord)) {
    fputc (dword & 0xff, file);
    dword >>= 8;
    i++;
  }
#endif
}

void
write_long (FILE *file, Long long_val)
{
#ifdef DEBUG
  printf ("Writing one long at position %d\n", wcounter);
  wcounter += sizeof (Long);
#endif

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
  fwrite (&long_val, sizeof (Long), 1, file);
#else
  int i = 0;

  while (i < sizeof (Long)) {
    fputc (long_val & 0xff, file);
    long_val >>= 8;
    i++;
  }
#endif
}
