/*
    xmms-rplay is an output plugin for xmms that talks to rplay
    Copyright (C) 2002-2003 lmoore@tump.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    thanks to esdout for guidance.
 */
#include <xmms/configfile.h>
#include <xmms/util.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <rplay.h>
#include "rplayout.h"

static GtkWidget *configure_win;
static GtkWidget *server_host, *server_port, *buffer_size;

void rp_about() {
  static GtkWidget *dialog;

  if (dialog != NULL) {
    return;
  }

  dialog = xmms_show_message(
    "About RPlay Plugin",
    "xmms-rplay (c) 2002 -- lantz moore <lmoore@tump.com>\n",
    "Ok", FALSE, NULL, NULL);
  gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                     &dialog);
}

void rp_init() {
  ConfigFile    *cfgfile;

  cfgfile = xmms_cfg_open_default_file();

  memset(&rp_config, 0, sizeof(RPlayOutConfig));
  rp_config.port = RPTP_PORT;
  rp_config.buffer_size = 65536;

  xmms_cfg_read_string(cfgfile, "RPlay", "server", &rp_config.server);
  xmms_cfg_read_int(cfgfile, "RPlay", "port", &rp_config.port);
  xmms_cfg_read_int(cfgfile, "RPlay", "buffer_size", &rp_config.buffer_size);
  xmms_cfg_free(cfgfile);

  if (!rp_config.server) {
    rp_config.server = g_strdup("localhost");
  }
}

static void rp_ok_callback(GtkWidget *widget, gpointer data) {
  ConfigFile    *cfgfile;

  if (rp_config.server) {
    g_free(rp_config.server);
  }
  rp_config.server = g_strdup(gtk_entry_get_text(GTK_ENTRY(server_host)));
  rp_config.port = atoi(gtk_entry_get_text(GTK_ENTRY(server_port)));
  rp_config.buffer_size = atoi(gtk_entry_get_text(GTK_ENTRY(buffer_size)));

  cfgfile = xmms_cfg_open_default_file();
  xmms_cfg_write_string(cfgfile, "RPlay", "server", rp_config.server);
  xmms_cfg_write_int(cfgfile, "RPlay", "port", rp_config.port);
  xmms_cfg_write_int(cfgfile, "RPlay", "buffer_size", rp_config.buffer_size);
  xmms_cfg_write_default_file(cfgfile);
  xmms_cfg_free(cfgfile);
}

void rp_configure() {
  GtkWidget *vbox, *hbox, *label, *button;
  char  tmp[256];

  if (configure_win) {
    gdk_window_raise(configure_win->window);
    return;
  }

  configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_signal_connect(GTK_OBJECT(configure_win), "destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                     &configure_win);
  gtk_window_set_title(GTK_WINDOW(configure_win),
                       "RPlay Plugin Configuration");
  gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
  gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(configure_win), vbox);

  hbox = gtk_hbox_new(FALSE, 5);
  label = gtk_label_new("Host:");
  server_host = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(server_host), rp_config.server);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), server_host, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 5);
  label = gtk_label_new("Port:");
  server_port = gtk_entry_new_with_max_length(5);
  sprintf(tmp, "%d", rp_config.port);
  gtk_entry_set_text(GTK_ENTRY(server_port), tmp);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), server_port, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 5);
  label = gtk_label_new("Buffer:");
  buffer_size = gtk_entry_new_with_max_length(6);
  sprintf(tmp, "%d", rp_config.buffer_size);
  gtk_entry_set_text(GTK_ENTRY(buffer_size), tmp);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), buffer_size, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 5);

  button = gtk_button_new_with_label("Ok");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(rp_ok_callback), NULL);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(configure_win));
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);

  button = gtk_button_new_with_label("Cancel");
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(configure_win));
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  gtk_widget_show_all(configure_win);
}

