/*      xmms - jack output plugin
 *    Copyright (C) 2004      Chris Morgan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Contains code Copyright (C) 1998-2000 Mikael Alm, Olle Hallnas,
 *  Thomas Nillson, 4Front Technologies and Galex Yen
 */

#include "jack.h"

#include <xmms/configfile.h>
#include <gtk/gtk.h>

extern jackconfig jack_cfg;

static GtkWidget *configure_win = NULL, *vbox;

static GtkWidget *GTK_isTraceEnabled;
static GtkWidget *bbox, *ok, *cancel;

static void configure_win_ok_cb(GtkWidget * w, gpointer data)
{
	ConfigFile *cfgfile;
	gchar *filename;

	jack_cfg.isTraceEnabled = (gint) GTK_CHECK_BUTTON(GTK_isTraceEnabled)->toggle_button.active;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfgfile = xmms_cfg_open_file(filename);
	if (!cfgfile)
		cfgfile = xmms_cfg_new();

	xmms_cfg_write_boolean(cfgfile, "jack", "isTraceEnabled", jack_cfg.isTraceEnabled);
	xmms_cfg_write_file(cfgfile, filename);
	xmms_cfg_free(cfgfile);

	g_free(filename);

	gtk_widget_destroy(configure_win);
}

void jack_configure(void)
{

	if (!configure_win)
	{
		configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);
		gtk_window_set_title(GTK_WINDOW(configure_win), ("jack Plugin configuration"));
		gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(configure_win), vbox);

        /* create a check_button */
        GTK_isTraceEnabled = gtk_check_button_new_with_label("Enable debug printing");
        gtk_box_pack_start(GTK_BOX(vbox), GTK_isTraceEnabled, FALSE, FALSE, 0);
        gtk_widget_show(GTK_isTraceEnabled);

        /* set the state of the check_button based upon the value of */
        /* isTracingEnabled */
        GTK_CHECK_BUTTON(GTK_isTraceEnabled)->toggle_button.active = jack_cfg.isTraceEnabled;

        /* add the box for the ok/canceled buttons at the bottom */
        bbox = gtk_hbox_new(FALSE, 10);
        gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label(("Ok"));
		gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(configure_win_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label(("Cancel"));
		gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show(bbox);
		gtk_widget_show(vbox);
		gtk_widget_show(configure_win);
	}
	else
		gdk_window_raise(configure_win->window);
}
