/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  FM Radio plug-in v1.5
 *  Copyright (C) 1999 Julien Viard <Julien.Viard@enst.fr>
 *  
 *  Radio acces routines from Keith Wesolowski (wesolows@cs.unr.edu)
 *  GRadio 1.0.0
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "radio.h"
#ifndef __FreeBSD__

static GtkWidget *radio_configure_win, *vbox, *notebook;
static GtkWidget *dev_vbox, *dev_frame, *dev_table, *dev_label, *dev_entry;
static GtkWidget *volume_vbox, *volume_frame, *volume_box, *volume_oss,
         *volume_drive;
static GtkWidget *bbox, *ok, *cancel;

static void radio_configurewin_ok_cb(GtkWidget * w, gpointer data)
{
	ConfigFile *cfgfile;
	gchar *filename;

	g_free(radio_cfg.device);
	radio_cfg.device = g_strdup(gtk_entry_get_text(GTK_ENTRY(dev_entry)));

	radio_cfg.use_oss_mixer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(volume_oss));

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfgfile = xmms_cfg_open_file(filename);
	if (!cfgfile)
		cfgfile = xmms_cfg_new();

	xmms_cfg_write_string(cfgfile, "Radio", "device", radio_cfg.device);
	xmms_cfg_write_boolean(cfgfile, "Radio", "use_oss_mixer", radio_cfg.use_oss_mixer);
	xmms_cfg_write_file(cfgfile, filename);
	xmms_cfg_free(cfgfile);

	g_free(filename);

	gtk_widget_destroy(radio_configure_win);
}

void radio_configure(void)
{
	if (!radio_configure_win)
	{
		radio_configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(radio_configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &radio_configure_win);
		gtk_window_set_title(GTK_WINDOW(radio_configure_win), "FM Radio Player Configuration");
		gtk_window_set_policy(GTK_WINDOW(radio_configure_win), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(radio_configure_win), GTK_WIN_POS_MOUSE);
		gtk_container_border_width(GTK_CONTAINER(radio_configure_win), 10);

		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(radio_configure_win), vbox);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

		dev_vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(dev_vbox), 5);

		dev_frame = gtk_frame_new("Device:");
		gtk_box_pack_start(GTK_BOX(dev_vbox), dev_frame, FALSE, FALSE, 0);

		dev_table = gtk_table_new(2, 2, FALSE);
		gtk_container_set_border_width(GTK_CONTAINER(dev_table), 5);
		gtk_container_add(GTK_CONTAINER(dev_frame), dev_table);
		gtk_table_set_row_spacings(GTK_TABLE(dev_table), 5);
		gtk_table_set_col_spacings(GTK_TABLE(dev_table), 5);

		dev_label = gtk_label_new("Device:");
		gtk_misc_set_alignment(GTK_MISC(dev_label), 1.0, 0.5);
		gtk_table_attach_defaults(GTK_TABLE(dev_table), dev_label, 0, 1, 0, 1);
		gtk_widget_show(dev_label);

		dev_entry = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(dev_entry), radio_cfg.device);
		gtk_table_attach_defaults(GTK_TABLE(dev_table), dev_entry, 1, 2, 0, 1);
		gtk_widget_show(dev_entry);


		gtk_widget_show(dev_table);
		gtk_widget_show(dev_frame);
		gtk_widget_show(dev_vbox);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), dev_vbox, gtk_label_new("Device"));

		volume_vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(volume_vbox), 5);

		volume_frame = gtk_frame_new("Volume setting:");
		gtk_box_pack_start(GTK_BOX(volume_vbox), volume_frame, FALSE, FALSE, 0);

		volume_box = gtk_vbox_new(5, FALSE);
		gtk_container_add(GTK_CONTAINER(volume_frame), volume_box);

		volume_oss = gtk_radio_button_new_with_label(NULL, "OSS Mixer");
		gtk_box_pack_start(GTK_BOX(volume_box), volume_oss, FALSE, FALSE, 0);
#if !defined(HAVE_SYS_SOUNDCARD_H) && !defined(HAVE_MACHINE_SOUNDCARD_H)
		gtk_widget_set_sensitive(volume_oss, FALSE);
#endif

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(volume_oss), 
		                radio_cfg.use_oss_mixer );

		gtk_widget_show(volume_oss);

		volume_drive = gtk_radio_button_new_with_label_from_widget(
		                GTK_RADIO_BUTTON(volume_oss), "Radio card");
		gtk_box_pack_start(GTK_BOX(volume_box), volume_drive, 
		                FALSE, FALSE, 0);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(volume_drive), 
		                !radio_cfg.use_oss_mixer);
		gtk_widget_show(volume_drive);

		gtk_widget_show(volume_box);
		gtk_widget_show(volume_frame);
		gtk_widget_show(volume_vbox);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), volume_vbox, gtk_label_new("Volume"));

		gtk_widget_show(notebook);

		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label("Ok");
		gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(radio_configurewin_ok_cb), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_show(ok);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label("Cancel");
		gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(radio_configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show(bbox);

		gtk_widget_show(vbox);
		gtk_widget_show(radio_configure_win);
	}
}

#endif
