#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>

#include <fox-1.2/fx.h>
#include <fox-1.2/FXPNGIcon.h>

#include "XFileExplorer.h"
#include "FilePanel.h"
#include "File.h"
#include "icons.h"

// Global variables
FXMainWindow *mainWindow;
FXString startdir;
char **args;

// Standard X Window arrow cursor definition
#define left_ptr_width 16
#define left_ptr_height 16
#define left_ptr_x_hot 3
#define left_ptr_y_hot 1
static const FXuchar left_ptr_bits[] = {
                                  0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x38, 0x00, 0x78, 0x00, 0xf8, 0x00,
                                  0xf8, 0x01, 0xf8, 0x03, 0xf8, 0x07, 0xf8, 0x00, 0xd8, 0x00, 0x88, 0x01,
                                  0x80, 0x01, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00};

#define left_ptrmsk_width 16
#define left_ptrmsk_height 16
static const FXuchar left_ptrmsk_bits[] = {
                                     0x0c, 0x00, 0x1c, 0x00, 0x3c, 0x00, 0x7c, 0x00, 0xfc, 0x00, 0xfc, 0x01,
                                     0xfc, 0x03, 0xfc, 0x07, 0xfc, 0x0f, 0xfc, 0x0f, 0xfc, 0x01, 0xdc, 0x03,
                                     0xcc, 0x03, 0x80, 0x07, 0x80, 0x07, 0x00, 0x03};

// Usage message
#define USAGE_MSG	_("\
Usage: xfe [startdir] [options] \n\
\n\
    [startdir] is the path to the initial directory you want to\n\
    open on start up.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --help                  Print (this) help screen and exit.\n\
        --version               Print version information and exit.\n\
\n")


int main(int argc,char *argv[])
{
    char *title   = "Xfe";
	char *regname = "Xfe";
	int i;
	char *strptr;

#ifdef HAVE_SETLOCALE
  	// Set locale via LC_ALL.
  	setlocale (LC_ALL, "");
#endif

#if ENABLE_NLS
  	// Set the text message domain.
  	bindtextdomain (PACKAGE, LOCALEDIR);
  	textdomain (PACKAGE);
#endif

	// Parse basic arguments
	for(i = 1; i < argc; i++)
	{
	    strptr = argv[i];
	    if(strptr == NULL)
		continue;

	    // Help
	    if(strstr(strptr, "-h") || strstr(strptr, "--h"))
	    {
			fprintf(stdout,USAGE_MSG);
			exit(0);
	    }
		// Version
		else if(strstr(strptr, "-v") || strstr(strptr, "--v"))
		{
			fprintf(stdout,"%s version %s\n",PACKAGE,VERSION);
			exit(0);
		}
		else
	    {
			// Other arguments will be handled later
	    }
	}

    // Global variable
	args = argv;

	// Application creation
    FXApp* application=new FXApp(regname,NULL);
    application->init(argc,argv);

    // Redefine the default cursor to get the standard X Window arrow cursor
    FXCursor* left_ptr=new FXCursor(application,left_ptr_bits,left_ptrmsk_bits,left_ptr_width,left_ptr_height,left_ptr_x_hot,left_ptr_y_hot);
    application->setDefaultCursor(DEF_ARROW_CURSOR,left_ptr);

    // Font definition
   /*
    FXFontDesc fontdesc;
    if(fxparsefontdesc(fontdesc,application->reg().readStringEntry("SETTINGS","font","[helvetica] 100 500 1 0 0 0")))
    {
        FXFont* normalFont=new FXFont(application,fontdesc);
        application->setNormalFont(normalFont);
    }
	*/

	FXString fontspec;
	fontspec=application->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
	if(!fontspec.empty())
	{
    	FXFont* normalFont=new FXFont(application,fontspec);
        application->setNormalFont(normalFont);
    }
 
    if (getuid()==0)
        title="Xfe (root)";

	// Icons
    FXIcon *miniicon=new FXPNGIcon(application,miniFileManager);
    FXIcon *bigicon=new FXPNGIcon(application,FileManager);

	// If given, start in indicated directory
	if(argc==2)
	{
		startdir=argv[1];
		startdir=::filePath(startdir);
	}
	else
		startdir="";
   	mainWindow=new XFileExplorer(application,title,bigicon,miniicon);
	application->create();
   	application->run();
}
