#ifndef FILE_H
#define FILE_H

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fox-1.2/fx.h>

int statout(const char *filename, struct stat *buf);
int lstatout(const char *filename, struct stat *buf);
#ifdef linux
int mtlstat(const char *filename, struct stat *buf);
#endif
unsigned long long dirsize(char *path);
unsigned long long dirpath( char *path);
void hSize(FXchar* size,FXchar *hsize);
FXString filePath(const FXString path);
FXString filePath(const FXString path, const FXString dir);
FXint isEmptyDir(const FXString directory);
FXString quote(const FXString& file,FXbool forcequotes);
FXString dequote(const FXString& file);
FXbool exists(const FXString& file);
FXbool isDirectory(const FXString& file);
FXbool isFile(const FXString& file);
FXbool isLink(const FXString& file);
FXbool info(const FXString& file,struct stat& inf);
FXString readlink(const FXString& file);

// File operations
enum
{	
	COPY,
	RENAME,
	MOVE,
	SLINK,
	DELETE,
	CHMOD,
	CHOWN,
	EXTRACT,
	ARCHIVE,
#if defined(linux)
	RPM_INSTALL,
	RPM_UNINSTALL,
	MOUNT,
	UNMOUNT
#endif
};

// To search visited inodes
struct inodelist
{
    ino_t st_ino;
    inodelist *next;
};

class File : public FXDialogBox
{
    FXDECLARE(File)
protected:
	int checkTimeout(FXTimer *timer);
    long fullread(int fd, unsigned char *ptr, long len);
    long fullwrite(int fd, const unsigned char *ptr, long len);
    FXbool copyfile(const FXString& source, const FXString& target);
	FXbool copyrec(const FXString& source,const FXString& target,inodelist* inodes);
    FXbool copydir(const FXString& source,const FXString& target,struct stat& parentstatus,inodelist* inodes);
    int rchmod(char *path, char *file, mode_t mode, FXbool dironly);
    int rchown(char *path, char *file, uid_t uid, gid_t gid, FXbool dironly);
    FXLabel *uplabel;
    FXLabel *downlabel;
    FXProgressBar *pbar;
	FXButton *cancelButton;
	FXTimer *timer;
	FXbool overwrite;
	FXbool overwrite_all;
	FXbool skip_all;

public:
    File()
    {}
	~File();
    void create();
    File(FXApp* a, FXString title, const unsigned int operation);

	enum 
	{
		ID_CANCEL_BUTTON=FXDialogBox::ID_LAST,
		ID_TIMEOUT,
		ID_LAST
	};

	FXbool allowPdialog;
	FXbool isCancelled;
    FXbool copy(const FXString& source,const FXString& target);
    FXbool rename(const FXString& source,const FXString& target);
    FXbool move(const FXString& source,const FXString& target);
    FXbool symlink(const FXString& source,const FXString& target);
    FXbool remove(const FXString& file);

    int chmod(char *path, char *file, mode_t mode, FXbool rec, FXbool dironly=FALSE);
    int chown(char *path, char *file, uid_t uid, gid_t gid, FXbool rec, FXbool dironly=FALSE);
	int extract(FXString name, FXString dir,FXString cmd);
	int archive(FXString name, FXString cmd);

#if defined(linux)
	int mount(FXString dir, FXString msg, FXString cmd, unsigned int op);
	int rpmInstall(FXString name, FXString cmd);
	int rpmUninstall(FXString name, FXString cmd);
#endif
	long onCmdCancel(FXObject*, FXSelector,void*);
    long onTimeout(FXObject*,FXSelector,void*);
};
#endif


