#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "brag1.img",
      "brag2.img",
      "brag3.img",
      "brag4.img"
};

PRIVATE Pixmap pixmap[4];
PRIVATE Pixmap pixmap_mask[4];
PRIVATE GC gc[4];

void BragSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;

      for(c_no = 0 ; c_no < 4 ; c_no++) {
            int x,y;

            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);

            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void BragFree()
{
      int i;

      for(i = 0 ; i < 4 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void BragInit(enemy_no)
     int enemy_no;
{
      int i;
      
      for(i = 0 ; i < ENEMY_MAX ; i++) {
	    if(!enemy[i].enemy_no){

		  enemy[i].enemy_no = BRAG;
		  enemy[i].x.dummy = (XSIZE/2-16)*65536;
		  enemy[i].y.dummy = 180*65536;
		  enemy[i].tmp1 = 0;
		  i = 65536;
	    }
      }
}

int Brag(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].y.dummy -= 16*65536;
      enemy[enemy_no].tmp1++;
      enemy[enemy_no].tmp1 &= 3;
      
      if(enemy[enemy_no].y.dummy < 0)
	{
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[enemy[enemy_no].tmp1],
			gc[enemy[enemy_no].tmp1],
			CSIZE,CSIZE);	      
        }
      return 0;
}



