#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "bacu11.img",
      "bacu12.img",
      "bacu21.img",
      "bacu22.img",
      "bacu31.img",
      "bacu32.img",
      "bacu41.img",
      "bacu42.img",
      "bacu51.img",
      "bacu52.img",
      "bacu61.img",
      "bacu62.img"
};

PRIVATE Pixmap pixmap[6];
PRIVATE Pixmap pixmap_mask[6];
PRIVATE GC gc[6];
PRIVATE int bc_anim[] = {
      0,0,0,0,0,0,
      1,1,1,1,1,1,
      2,2,2,2,2,2,
      3,3,3,3,3,3,
      4,4,4,4,4,4,
      5,5,5,5,5,5
};

void BacuSetChar()
{
      int c_no;
      char img2[2*CSIZE*CSIZE],img[CSIZE*CSIZE] , mask[256];
      int x,y;
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 6 ; c_no++) {
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no*2]);
            LoadChar(tpath,img , sizeof(img));
	    
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    for(y = 0 ; y < CSIZE ; y++)
	      for(x = 0 ; x < CSIZE ; x++)
		img2[y*2*CSIZE+x] = img[y*CSIZE+x];
	    
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no*2+1]);
            LoadChar(tpath,img , sizeof(img));
	    
	    for(y = 0 ; y < CSIZE ; y++)
              for(x = 0 ; x < CSIZE ; x++)
                img2[y*CSIZE*2+x+CSIZE] = img[y*CSIZE+x];
	    
            pixmap[c_no] = XCreatePixmap(d,w,2*CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));

	    for(y = 0 ; y < CSIZE ; y++)
              for(x = 0 ; x < CSIZE*2 ; x++) {
                    if(img2[2*y*CSIZE+x] != 100) {
                          mask[y*8+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img2[2*y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,2*CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void BacuFree()
{
      int i;

      for(i = 0 ; i < 6 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }

}

void BacuInit(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].enemy_no = BACURA;
      enemy[enemy_no].tmp1 = 0;
      enemy[enemy_no].tmp2 = 1;
      enemy[enemy_no].tmp3 = 45;
      enemy[enemy_no].x.dummy = 65536*( (rand() % (XSIZE-CSIZE*2)));
      enemy[enemy_no].y.dummy = -(rand() & 31+32)*65536;
      enemy[enemy_no].vx = 0;
}

int Bacura(enemy_no)
     int enemy_no;
{
      int yararetaBC = 0;
      int i;
      register sx,sy;

      enemy[enemy_no].y.dummy +=32768*3*STPF;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      enemy[enemy_no].tmp1 +=STPF;
      enemy[enemy_no].tmp1 %= 36;

      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;

              if( (shot[i].x.sht[UNION] - sx) > -16 
		 && (shot[i].x.sht[UNION] - sx) < 48
                 && (shot[i].y.sht[UNION] - sy) > -24 
		 && (shot[i].y.sht[UNION] - sy) < 24) {
		    shot[i].flag = 0;
		    enemy[enemy_no].tmp3--;
	      }
        }
      
      if(!enemy[enemy_no].tmp3) {
	    score += 500;
	    BombInit(enemy_no);
	    return 0;
      }
      
      if(enemy[enemy_no].y.sht[UNION] > YSIZE)
        enemy[enemy_no].enemy_no = 0;
      else 
	{
	      if( (jx.sht[UNION] - sx) > -16 && (jx.sht[UNION] - sx) < 48
                 && (jy.sht[UNION] - sy) > -24 && (jy.sht[UNION] - sy) < 24)
                {
                      yararetaBC = 1;
                }
	      
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[bc_anim[enemy[enemy_no].tmp1]],
			gc[bc_anim[enemy[enemy_no].tmp1]],
			2*CSIZE,CSIZE);
        }
      return yararetaBC;
}

      
