// $Id: CallbacksHeightOperations.cpp,v 1.15 2003/02/27 23:44:53 zongo Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <iostream>

#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"

#include "../Main.h"
#include "../Application.h"
#include "../HFEditHeight.h"
#include "../HeightOps.h"

#include "CallbacksHeight.h"
#include "UIGtk.h"

/**
 * Height operations
 */


// Callback not managed by Glade, removed it from callbacks.{h|cpp}
static void
on_HBEffectOption_clicked (GtkMenuShell *menu_shell,
                    gpointer data)
{
  
  GtkWidget* active_item = gtk_menu_get_active (GTK_MENU(menu_shell));
  int item_index = g_list_index (menu_shell->children, active_item);

  //std::cerr << "In on_option_selected active: " << item_index << std::endl;
  UpdateHeightAttenuationType(item_index);
}



// Set the transform list to the list given
void InitHeightOps(const HeightOpList& ops)
{
  // FIXME non const char for CLists sucks
  gchar *columns[] = { (char*)"" };

  GtkWidget* widget = lookup_widget(GTK_WIDGET(g_MainWindow), "TransformList");
  GtkCList* list = GTK_CLIST( widget );

  gtk_clist_freeze(list);
  gtk_clist_clear(list);

  // FIXME use for_each algorithm
  for (HeightOpList::const_iterator i = ops.begin();
        i != ops.end() ; 
        ++i)
  {
    char* name = const_cast<char*>((*i)->m_Name.c_str());
    GdkPixmap* pixmap;
    GdkBitmap* bitmap;

    gint row = gtk_clist_append(list, columns);
    
    GtkPixmap* w = GTK_PIXMAP( create_pixmap(g_MainWindow,
					     (*i)->m_Icon.c_str()) );
    gtk_pixmap_get( w, &pixmap, &bitmap);
    gtk_clist_set_pixtext(list, row, 0, name, 4, pixmap, bitmap);

  }
  
  gtk_clist_thaw(list);
  
  // Connect signal to Attenuation optionmenu (glade does not manage it yet)
  GtkWidget* option_menu = lookup_widget (g_MainWindow, "HBEffectOption");
  gtk_signal_connect (GTK_OBJECT (GTK_OPTION_MENU (option_menu)->menu), "deactivate", 
      GTK_SIGNAL_FUNC (on_HBEffectOption_clicked), NULL);


}

static int s_Operation = 0;
static int s_BrushSize = 1;
static scalar s_Strength = 1.0;
static scalar s_Attenuation = 0.0;
  
static void CreateAndSetNewTool()
{
  Application* a = Application::GetApplication();

  // Passed an height field of 0, the Application should deal with it
  a->SetTool(a->NewHeightTool (s_Operation, s_BrushSize, s_Attenuation,
			       s_Strength));
}

// Height tool has been chosen
void UpdateHeight()
{
  CreateAndSetNewTool();
}

// Height size has been changed
void UpdateHeightSize(int size)
{
  s_BrushSize = size;
  CreateAndSetNewTool();
}

// Height strength has been changed
void  UpdateHeightStrength(int strength)
{
  s_Strength = static_cast<float>(strength);
  CreateAndSetNewTool();
}

// Height atenuation type has been changed
void UpdateHeightAttenuationType(int type)
{
  //std::cerr << "Attenuation: " << type << std::endl;
  float att = 0.0f;
  
  // Hard coded stuff, but that must be made somewhere
  if ( (0 < type) && (type < 3) )
  {
    att = (float) type;
  }
  
  s_Attenuation = att;
  CreateAndSetNewTool();
}
  
// A height operation has been selected for editing
void SelectHeightOperation(int transform)
{
  s_Operation = transform;
  CreateAndSetNewTool();
}
  
  
