#ifndef WE_TOOLHELPER_H
#define WE_TOOLHELPER_H

// Forward declarations.
class Tool;
class World;
class Command;
class CommandStack;
class EntityOpList;
class HeightOpList;
class ViewWidget;
class TerrainView;

class ToolHelper
{
   public:
      ToolHelper ();
      virtual ~ToolHelper ();

      // Undo/Redo operations
      void Undo();
      void Redo();
      void ClearCommands() const;
      void PushCommand(Command*);

      // Tool operations
      void SetTool(Tool*);
      Tool *NewEntityTool (int type);
      Tool *NewHeightTool (int type, int s, float a, float h);

      void SetView (ViewWidget *view);
      virtual TerrainView *GetTerrain() const = 0;

   public:
      // To be implemented
      virtual World* GetWorld() = 0;

   private:
      int m_UndoLevel;
      int m_MaxUndoLevel;
      CommandStack* m_Commands;
      EntityOpList *m_EntityOps;
      HeightOpList *m_HeightOps;
};

#endif

