// $Id: HFEditHeight.cpp,v 1.18 2003/02/27 23:43:40 zongo Exp $

#include <stdlib.h>
#include <math.h>

#include "HeightOps.h"
#include "HFEditHeight.h"

HFEditHeight::HFEditHeight(World* world, int type, int size, float att, float str) :
  HeightFieldChange( world ),
  m_Operation( type ),
  m_BrushSize( size ),
  m_Attenuation( att ),
  m_Strength( str )
{
}


HFEditHeight::~HFEditHeight()
{
}


void 
HFEditHeight::Apply(int gx, int gz) 
{
  const int brush = m_BrushSize;
  const int radius2 = brush * brush;
  const float radius2f = static_cast<float>( radius2 );

  ClampCoord(gx, gz);

  int bx = gx - brush - 1;
  int bz = gz - brush - 1;
  ClampCoord(bx, bz);

  int ex = gx + brush;
  int ez = gz + brush;
  ClampCoord(ex, ez);

  for (int z = bz; z <= ez; ++z)
  {
    const int dz = gz - z;
    const int part2 = radius2 - dz * dz;      
      
    for (int x = bx; x <= ex; ++x)
    {
      const int dx = gx - x;

      // dist2 = radius - distance
      const int factor2 = part2 - dx * dx;

      if (0 <= factor2)
      {
        ApplyAtPoint(x, z, float(factor2) / radius2f);
      }

    }
  }

  m_World->Invalidate ((float)bx, (float)bz, (float)ex, (float)ez);
}


float 
HFEditHeight::ComputeStandardAttenuation(float factor)
{
  float coeff = 1.0f;

  if (0.1f < m_Attenuation)
  {
    // Factor is in the square order to the center distance
    coeff *= powf(factor, m_Attenuation / 2.0f);
  }

  return coeff;
}



