/* startprogop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: startprogop.h,v 1.10 2004/10/27 21:09:24 ralf Exp $ */

#ifndef STARTPROGOP_H
#define STARTPROGOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>

class StartProgOp:public FunctionProto
{
public:
  StartProgOp();
  virtual ~StartProgOp();
  StartProgOp( const StartProgOp &other );
  StartProgOp &operator=( const StartProgOp &other );

  virtual StartProgOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int doconfigure(int mode);

  typedef enum {STARTPROGOP_START_NORMAL=0,
                STARTPROGOP_START_IN_TERMINAL,
                STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY,
                STARTPROGOP_SHOW_OUTPUT} startprogstart_t;
  void setStart(startprogstart_t);
  void setGlobal(bool);
  void setRequestFlags(bool);
  void setInBackground( bool );
  void setViewStr( const char * );
protected:
  static const char *name;
  // Infos to save

  startprogstart_t startprogstart;

  char *view_str;
  bool global,requestflags;
  bool inbackground;
  
  // temp variables
  Lister *startlister,*endlister;
  
  startprogstart_t tstartprogstart;
  char *tview_str;
  bool tglobal,trequestflags;
  bool tinbackground;
  
  int normalmodestartprog();
};

#endif
