/* lowlevelfunc.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: lowlevelfunc.h,v 1.21 2004/10/27 20:40:53 ralf Exp $ */

#ifndef LOWLEVELFUNC_H
#define LOWLEVELFUNC_H

#include "aguixdefs.h"
#include "time.h"

void *_allocsafe(size_t size);
void waittime(unsigned long msec);
#ifdef USE_MEM_SYSTEM
void _freesafe(void *p);
void _memsystemcheck();
#else
#define _freesafe(P) free(P)
#endif /* USE_MEM_SYSTEM */
char *dupstring(const char *str);
char *catstring(const char *str1,const char *str2);
char *shrinkstring(const char *str,int maxlen);
int WriteLong2Str(char *buffer,loff_t size);
int MakeLong2NiceStr(char *buffer,loff_t size);
int NiceLongSize(loff_t value);
const char *GetLong2Str( loff_t size );

// this is the number of bytes need for a "nice" number with dots after 3 digits
// it's the number of bytes for the type plus all dots plus 1 for the trailing zero
// Because this define shouldn't do any runtime calculation I use this
// approx.: 1 dot for every byte. You cannot fill 3 digits with one byte so
// it's more then really needed
#define A_BYTESFORNICENUMBER(x) ( A_BYTESFORNUMBER(x) + sizeof(x) + 1 )

double diffgtod( struct timeval *tv1, struct timeval *tv0 );
long ldiffgtod( struct timeval *tv1, struct timeval *tv0 );
long ldiffgtod_m( const struct timeval *tv1, const struct timeval *tv0 );

#ifdef DEVELOPER
  #define debugmsg(P) printf(P)
#else
  #define debugmsg(P) 
#endif

int AGUIX_getQuoteMode( const char *str );
char *AGUIX_catTrustedAndUnTrusted( const char *str1, const char *str2 );
char *AGUIX_prepareForSingleQuote( const char *str1 );
char *AGUIX_unquoteString( const char *str1 );
char *AGUIX_catQuotedAndUnQuoted( const char *str1, const char *str2 );
char *AGUIX_fixBackslashed( const char *str1 );

#endif /* LOWLEVELFUNC_H */

