
#include "kde_interface.h"
#include <qstringlist.h>
#include "../QDiccionarios.h"
#include "../DiccionarioBase.h"
#include "../miniwindow.h"

KdeInterface::KdeInterface(QDiccionarios *dictionaries, 
                 QObject *parent, const char *name) 
	: QObject(parent,name), DCOPObject("kwordtrans")
{
	dicts = dictionaries;
}

KdeInterface::~KdeInterface() {
}

QString KdeInterface::translation(const QString& texto, const QString& alias,
                                  bool rich_text) 
{
	QString resultado;
	int index;

	DiccionarioBase * diccionario = dicts->find( alias, index );
	if (diccionario)
		diccionario->busca(texto, resultado, rich_text );
	return resultado;
}

QString KdeInterface::shortTranslation(const QString& texto, const QString& alias,
                                      bool rich_text) 
{
	QString resultado;
	int index;

	DiccionarioBase * diccionario = dicts->find( alias, index );
	if (diccionario)
		diccionario->busca(texto, resultado, rich_text );

	return diccionario->getBestMatch();
}

QString KdeInterface::showMiniWindow(const QString& texto, 
                                     const QString& alias, bool rich_text)
{
	QString resultado=translation(texto,alias,rich_text);

	MiniWindow::defaultWindow()->setCaption( "kwordtrans" );
	MiniWindow::defaultWindow()->setText( resultado );
#if QT_VERSION >= 300
	MiniWindow::defaultWindow()->browser()->setCursorPosition(1,1);
#endif
	MiniWindow::defaultWindow()->show();
	MiniWindow::defaultWindow()->setActiveWindow();
	MiniWindow::defaultWindow()->raise();

	return resultado;
}

QString KdeInterface::language1(const QString& alias) {
	int index;
	DiccionarioBase * diccionario = dicts->find( alias, index );
	if (diccionario)
		return diccionario->getIdioma1();

	return QString::null;
}

QString KdeInterface::language2(const QString& alias) {
	int index;
	DiccionarioBase * diccionario = dicts->find( alias, index );
	if (diccionario)
		return diccionario->getIdioma2();

	return QString::null;
}

QStringList KdeInterface::getListDictionaries() {
	QStringList lista;

	DiccionarioBase *dic;
	for (dic = dicts->first(); dic!=0; dic = dicts->next() ) {
		if (dic) lista.append( dic->getAlias() );
		qDebug("%s", dic->getAlias().latin1() );
	}

	return lista;
}

#include "kde_interface_skel.cpp"
#include "kde_interface.moc.cpp"

