#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# ifndef YYLMAX 
# define YYLMAX BUFSIZ
# endif 
#ifndef __cplusplus
# define output(c) (void)putc(c,yyout)
#else
# define lex_output(c) (void)putc(c,yyout)
#endif

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifdef YYLEX_E
	void yywoutput(wchar_t);
	wchar_t yywinput(void);
#endif
#ifndef yyless
	int yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
	void exit(int);
#ifdef __cplusplus
}
#endif

#endif
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
#ifndef __cplusplus
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#else
# define lex_input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif
#define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng;
#define YYISARRAY
char yytext[YYLMAX];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
# define insynset 2
# define outsynset 4
# define comment 6
# define indefinition 8
# define inframelist 10

# line 6 "wnlex.l"
/*

  wnlex.l - Lexical analyzer for WordNet lexicographer's files

*/

#include "typedef.h"
#include "consts.h"
#include "wnparse.h"   /* y.tab.h, renamed in the makefile */
#include "extern.h"


# line 17 "wnlex.l"
/*
  Need to override lex's default output() function, otherwise parsed
  text sometimes preceeds error messages.
*/

#undef output
#define output(c);

static char *Id = "$Id: wnlex.l,v 1.17 2003/03/27 15:26:49 wn Exp $";

int yyinhead=0;
int commentline=0;
int pcount=0;

static void fixdigit();
static void i_c_err();
static int outmess();
void yyerror(), yywarn();
char *strclone();


# line 37 "wnlex.l"
/*
 * Now some weird stuff to change the behavior of Lex so that it
 * remembers which state to start in even after returning a token.
 * This code depends on the particular skeleton code used by
 * your local lex.
 * Substituting "flex" for lex would almost certainly break this code
 * (not that I've looked at flex, but I doubt the internal variables
 * go by the same names.)
 * If there's some really weird behavior in some version of the
 * grinder's tokenizing when porting to machines other than Sun-[34]
 * suspect this.
 *
 */

static int yypreservestate=0;
#define REMEMBER(x) yypreservestate = x , BEGIN x
#define FORGET yypreservestate=0;

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;

# line 67 "wnlex.l"
/*
  * Now figure out where to begin.  Use a preserved state if there is one
  * or otherwise default to outsynset.
  */

 BEGIN (yypreservestate ? yypreservestate : outsynset);
#ifdef __cplusplus
/* to avoid CC and lint complaining yyfussy not being used ...*/
static int __lex_hack = 0;
if (__lex_hack) goto yyfussy;
#endif
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 74 "wnlex.l"
{
		REMEMBER(insynset);
		switch(curfilemode()) {
			case NOUN: return (NOUNSYNSET);
			case VERB: return (VERBSYNSET);
			case ADJ: return (ADJSYNSET);
			case ADV: return (ADVSYNSET);
		}
        }
break;
case 2:

# line 84 "wnlex.l"
{ 
		if (curfilemode()!= ADJ) {
			yywarn("Open-cluster symbol in non-adjective file (ignored)\n");
		} else {
			yyinhead=1; 
			return(OPENCLUS);  
		}
	}
break;
case 3:

# line 93 "wnlex.l"
{ 
		if (curfilemode()!= ADJ) {
			yywarn("Close-cluster symbol in non-adjective file (ignored)\n");
		} else {
			return(CLOSECLUS); 
		}
	}
break;
case 4:

# line 101 "wnlex.l"
{ 
		if (curfilemode()!= ADJ) {
			yywarn("Cluster separator symbol in non-adjective file (ignored)\n");
		} else {
			yyinhead=1;
			return('-');  
		}
	}
break;
case 5:

# line 110 "wnlex.l"
{ 
                     REMEMBER(outsynset);
		     yylval.number = atoi(yytext);
		     return(SYNSETKEY);
		     }
break;
case 6:

# line 116 "wnlex.l"
{
			if (curfilemode() == VERB) {
				REMEMBER(inframelist); 
				return(VERBFRAMES); 
			} else {
			       yyerror("frame list in non-verb file\n");
			}
		}
break;
case 7:

# line 125 "wnlex.l"
{ yyinhead=0; REMEMBER(outsynset); return('}'); }
break;
case 8:

# line 127 "wnlex.l"
;
break;
case 9:

# line 128 "wnlex.l"
{ pcount++;  }
break;
case 10:

# line 129 "wnlex.l"
{
		if (!(--pcount)) {
			commentline=0;
			REMEMBER(outsynset);
		} else {
			REMEMBER(comment);
		}
	}
break;
case 11:

# line 138 "wnlex.l"
{ commentline=yylineno; pcount++; REMEMBER(comment); }
break;
case 12:

# line 140 "wnlex.l"
{ /* skip this for now */ REMEMBER(insynset); }
break;
case 13:

# line 142 "wnlex.l"
{
			if (yytext[yyleng-1]=='"') 
				yytext[yyleng-1]=0;
			yylval.tx=strclone(yytext);
			fixdigit(yylval.tx);
			REMEMBER(insynset);

			if (curfilemode() == ADJ)
			    return(HEADWYRD);
			else {
			    return(WYRD);
			}
		}
break;
case 14:

# line 156 "wnlex.l"
{
			if (yytext[yyleng-1]=='"') 
				yytext[yyleng-1]=0;
			yylval.tx=strclone(yytext);
			fixdigit(yylval.tx);
			REMEMBER(insynset);
                        return(WYRD);
		}
break;
case 15:

# line 165 "wnlex.l"
{
			yytext[yyleng-1]=0; /* strip colon */
			yylval.tx=strclone(yytext);
			REMEMBER(insynset);
			return(FILENAME); 
		}
break;
case 16:

# line 172 "wnlex.l"
{
			yylval.number=ptrkind(yytext+1);
			REMEMBER(insynset);
			return(PTRSYM); 
		}
break;
case 17:

# line 178 "wnlex.l"
{
                yylval.number=atoi(yytext);
		REMEMBER(insynset);
		return(NUM);
        	}
break;
case 18:

# line 184 "wnlex.l"
{ REMEMBER(insynset); return('['); }
break;
case 19:

# line 186 "wnlex.l"
{ REMEMBER(insynset); return(']'); }
break;
case 20:

# line 188 "wnlex.l"
{ REMEMBER(insynset); return(','); }
break;
case 21:

# line 190 "wnlex.l"
{ REMEMBER(insynset); return('^'); }
break;
case 22:

# line 192 "wnlex.l"
{
		if (curfilemode() == ADJ) {
		    REMEMBER(insynset);
		    yylval.number=PADJ;
		    return(ADJCLASS);
		} else {
		    yyerror("adjective class specified in non-adjective file\n");
		}
	}
break;
case 23:

# line 202 "wnlex.l"
{
		if (curfilemode() == ADJ) {
		    REMEMBER(insynset);
		    yylval.number=NPADJ;
		    return(ADJCLASS);
		} else {
		    yyerror("adjective class specified in non-adjective file\n");
		}
	}
break;
case 24:

# line 212 "wnlex.l"
{ 
    			if (curfilemode() == ADJ) {
			    REMEMBER(insynset);
			    yylval.number=IPADJ;
			    return(ADJCLASS);
			} else {
			    yyerror("adjective class specified in non-adjective file\n");
			}
		}
break;
case 25:

# line 222 "wnlex.l"
{ REMEMBER(indefinition); pcount++; }
break;
case 26:

# line 224 "wnlex.l"
{ yymore(); pcount++; }
break;
case 27:

# line 226 "wnlex.l"
{ 
			if (--pcount) {
				yymore();  
			} else {
				yytext[yyleng-1]=0;
				yylval.tx=strclone(yytext);
				REMEMBER(insynset);
				return(DEFN);
			}
		}
break;
case 28:

# line 237 "wnlex.l"
{ 
			yylineno--;
			yywarn("Missing \")\" in definition-- definition ignored\n");
			yylineno++;
			REMEMBER(outsynset);
			pcount=0;
			return('}');
		}
break;
case 29:

# line 246 "wnlex.l"
{ yymore(); }
break;
case 30:

# line 248 "wnlex.l"
{ 
			yylval.number=atoi(yytext);
			REMEMBER(inframelist);
			return(NUM);
		}
break;
case 31:

# line 254 "wnlex.l"
{ REMEMBER(inframelist); return(',');}
break;
case 32:

# line 255 "wnlex.l"
{ REMEMBER(insynset); return(']');}
break;
case 33:

# line 256 "wnlex.l"
{ REMEMBER(outsynset); return('}');}
break;
case 34:

# line 257 "wnlex.l"
{ REMEMBER(indefinition); pcount++; }
break;
case 35:

# line 258 "wnlex.l"
	{ 
			yyerror("Forgot to close previous synset\n");
			REMEMBER(outsynset);
		}
break;
case 36:

# line 263 "wnlex.l"
;
break;
case 37:

# line 265 "wnlex.l"
{ i_c_err(*yytext); }
break;
case 38:

# line 266 "wnlex.l"
{ yyerror("Forgot to close previous synset\n"); }
break;
case 39:

# line 267 "wnlex.l"
{ i_c_err(*yytext); }
break;
case 40:

# line 269 "wnlex.l"
;
break;
case 41:

# line 270 "wnlex.l"
{ i_c_err(*yytext); }
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

# line 273 "wnlex.l"
static void i_c_err(c)
char c;
{
    char message[40];

    if (c)
	sprintf(message,"Illegal character %c\n",c);
    else
	sprintf(message,"NULL character in file?\n");
    yyerror(message);
}

static int outmess(s,file,lineno)
char *s;
int file,lineno;
{
    /*
     * YACC somtimes generates more "syntax error" messages than
     * we care to see-- generally there's one every time I generate
     * a message of my own.  I supress those.
     */
    if (strcmp(s,"syntax error") != 0) {
	fprintf(logfile, "%s, line %d: %s",
		PrintFileName(file),
		lineno, s);
	fflush(logfile);
	return(1);
    }
    return(0);
}

void yyerror(s)
char *s;
{
    if (outmess(s,curfilenum(),yylineno))
	errcount++;
}

void yywarn(s)
char *s;
{
    char mess[500];

    if (!nowarn) {		/* only print warnings if not suppressed */
	sprintf(mess,"warning: %s",s);
	outmess(mess,curfilenum(),yylineno);
    }
    if (verifyflag)		/* if verifying, count as error */
	errcount++;
}

yywrap()
{

    if (pcount) {
	fprintf(logfile, "%s: Comment started on line %d left open\n",
	       filelist[curfilenum()], commentline);
	errcount++;
    }
    return 1 ;
}

/*
 * Remove all quote characters from words
 */

static void fixdigit(s)
register char *s;
{
    register int i, j, l;

    l = strlen(s)+ 1;		/* make sure we get the NULL */
    i = 0;
    while (s[i]) {
	if (s[i] != '"')
	    i++;
	else {
	    for (j = i; j < l; j++)
		s[j] = s[j + 1];
	    l--;
	}
    }
}

/*
  Revision log:

  $Log: wnlex.l,v $
  Revision 1.17  2003/03/27 15:26:49  wn
  removed suffix from "+" in ptr definition

  Revision 1.16  2001/09/06 17:55:38  wn
  added code for synset keys

  Revision 1.15  2001/08/02 14:53:23  wn
  added ";c", ";u", ";r" for CLASSIFICATION

  Revision 1.14  2000/10/27 16:53:03  wn
  added [a-x] in ptr

  Revision 1.13  2000/07/11 15:20:06  wn
  added nominalization pointers

  Revision 1.12  1996/05/30 20:56:48  wn
  *** empty log message ***

 * Revision 1.11  1994/09/27  19:53:17  wn
 * added < to valid pointer llist
 *
 * Revision 1.10  1993/04/21  12:40:32  wn
 * added new ATTRIBUTE pointer (=)
 *
 * Revision 1.9  92/09/08  16:05:13  wn
 * *** empty log message ***
 *
 * Revision 1.8  92/08/20  13:52:17  wn
 * changed call to PrintFileName
 *
 * Revision 1.7  92/08/19  16:01:42  wn
 * added code to return ADVSYNSET and changed MARKER to PTRSYM
 *
 * Revision 1.6  92/03/26  13:42:24  wn
 * removed unused pointers
 *
 * Revision 1.5  92/02/18  16:56:09  wn
 * removed generic meronym and holonym pointers (% and #)
 *
 * Revision 1.4  92/01/03  12:17:47  wn
 * changed yywrap() to output msg to logfile and changed syntax of msg.
 * also increment errcount so grinder terminates with syntactic error
 *
 * Revision 1.3  91/12/13  15:59:27  wn
 * cleaned up static function declarations
 *
 * Revision 1.2  91/11/26  15:03:43  wn
 * added '\\' as pertainym pointer
 *
 * Revision 1.1  91/09/11  14:50:52  wn
 * Initial revision
 *
*/
int yyvstop[] = {
0,

36,
0, 

37,
39,
0, 

36,
37,
39,
0, 

37,
39,
0, 

13,
14,
37,
39,
0, 

25,
37,
39,
0, 

20,
37,
39,
0, 

13,
14,
37,
39,
0, 

37,
39,
0, 

17,
37,
39,
0, 

13,
14,
37,
39,
0, 

18,
37,
39,
0, 

19,
37,
39,
0, 

21,
37,
39,
0, 

14,
37,
39,
0, 

14,
37,
39,
0, 

37,
38,
39,
0, 

7,
37,
39,
0, 

41,
0, 

36,
41,
0, 

40,
0, 

41,
0, 

11,
41,
0, 

5,
41,
0, 

2,
41,
0, 

3,
41,
0, 

1,
41,
0, 

41,
-4,
0, 

8,
0, 

8,
36,
0, 

9,
0, 

10,
0, 

29,
0, 

29,
36,
0, 

28,
0, 

26,
29,
0, 

27,
0, 

35,
0, 

34,
0, 

31,
0, 

30,
0, 

32,
0, 

33,
0, 

13,
14,
0, 

13,
14,
0, 

14,
0, 

16,
0, 

13,
14,
0, 

15,
0, 

13,
14,
0, 

14,
0, 

17,
0, 

14,
0, 

14,
0, 

5,
0, 

4,
0, 

-4,
0, 

14,
0, 

23,
0, 

12,
0, 

22,
0, 

14,
0, 

24,
0, 

14,
0, 

14,
0, 

14,
0, 

6,
15,
0, 
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	3,14,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,13,	3,15,	
3,0,	0,0,	3,14,	0,0,	
32,79,	32,33,	0,0,	32,79,	
0,0,	0,0,	4,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,13,	40,81,	3,14,	
3,16,	21,57,	3,17,	32,79,	
58,57,	3,17,	3,18,	3,14,	
5,31,	59,57,	3,19,	61,84,	
3,20,	63,86,	3,21,	3,22,	
5,32,	5,33,	6,40,	5,34,	
4,19,	36,80,	36,80,	36,80,	
36,80,	36,80,	36,80,	36,80,	
36,80,	36,80,	36,80,	3,23,	
64,87,	40,82,	76,60,	85,89,	
92,93,	0,0,	0,0,	0,0,	
5,31,	5,31,	0,0,	5,31,	
0,0,	0,0,	5,31,	5,35,	
5,31,	0,0,	0,0,	0,0,	
0,0,	5,31,	0,0,	5,36,	
5,36,	3,24,	0,0,	3,25,	
3,26,	0,0,	78,88,	3,27,	
6,37,	3,27,	6,38,	4,24,	
3,28,	4,25,	4,26,	90,91,	
5,31,	0,0,	88,90,	3,27,	
0,0,	62,85,	4,28,	7,41,	
28,78,	91,92,	0,0,	0,0,	
0,0,	0,0,	0,0,	7,42,	
7,41,	3,29,	7,41,	3,30,	
0,0,	0,0,	0,0,	18,61,	
6,39,	0,0,	5,37,	4,29,	
5,38,	4,30,	66,65,	18,62,	
5,31,	66,65,	5,31,	18,63,	
66,65,	0,0,	18,64,	7,41,	
7,41,	0,0,	7,41,	0,0,	
5,31,	7,41,	7,43,	7,44,	
9,45,	0,0,	0,0,	0,0,	
7,41,	0,0,	7,41,	7,41,	
9,46,	9,47,	5,39,	9,45,	
53,53,	53,53,	53,53,	53,53,	
53,53,	53,53,	53,53,	53,53,	
53,53,	53,53,	0,0,	7,41,	
0,0,	0,0,	68,65,	0,0,	
0,0,	0,0,	11,13,	11,50,	
9,45,	9,45,	0,0,	9,45,	
0,0,	0,0,	9,45,	9,48,	
9,49,	68,65,	0,0,	0,0,	
68,65,	9,45,	0,0,	9,45,	
9,45,	0,0,	0,0,	0,0,	
0,0,	11,13,	0,0,	7,41,	
0,0,	7,41,	0,0,	0,0,	
0,0,	11,51,	0,0,	0,0,	
9,45,	11,52,	22,57,	7,41,	
0,0,	11,53,	11,53,	11,53,	
11,53,	11,53,	11,53,	11,53,	
11,53,	11,53,	11,53,	0,0,	
22,74,	22,74,	22,74,	22,74,	
22,74,	22,74,	22,74,	22,74,	
22,74,	22,74,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
9,45,	0,0,	9,45,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
9,45,	0,0,	0,0,	0,0,	
0,0,	0,0,	11,54,	0,0,	
16,56,	0,0,	16,57,	0,0,	
0,0,	16,57,	0,0,	0,0,	
0,0,	0,0,	0,0,	16,57,	
16,58,	16,57,	16,59,	16,59,	
16,59,	16,59,	16,59,	16,59,	
16,59,	16,59,	16,59,	16,59,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	11,55,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	16,57,	16,57,	16,57,	
16,57,	0,0,	0,0,	0,0,	
0,0,	16,57,	0,0,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	16,60,	16,60,	16,60,	
16,60,	19,65,	20,57,	19,66,	
19,65,	19,67,	19,65,	0,0,	
0,0,	0,0,	19,65,	19,65,	
0,0,	19,68,	20,70,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	20,71,	19,69,	
19,65,	19,65,	19,65,	0,0,	
19,65,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	0,0,	
19,65,	0,0,	19,65,	0,0,	
0,0,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	20,73,	
20,73,	20,73,	20,73,	23,70,	
0,0,	0,0,	19,65,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	23,71,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
23,72,	23,72,	23,72,	23,72,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
23,73,	23,73,	23,73,	23,73,	
27,75,	0,0,	27,60,	0,0,	
0,0,	27,60,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,60,	
27,76,	27,60,	27,77,	27,77,	
27,77,	27,77,	27,77,	27,77,	
27,77,	27,77,	27,77,	27,77,	
27,71,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	0,0,	0,0,	0,0,	
0,0,	27,60,	0,0,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	27,73,	27,73,	27,73,	
27,73,	60,75,	0,0,	60,60,	
0,0,	0,0,	60,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
60,60,	60,83,	60,60,	60,77,	
60,77,	60,77,	60,77,	60,77,	
60,77,	60,77,	60,77,	60,77,	
60,77,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	60,60,	60,60,	
60,60,	60,60,	70,57,	0,0,	
70,57,	0,0,	60,60,	70,57,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,57,	70,70,	70,57,	
70,59,	70,59,	70,59,	70,59,	
70,59,	70,59,	70,59,	70,59,	
70,59,	70,59,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	70,72,	
70,72,	70,72,	70,72,	72,56,	
0,0,	72,57,	0,0,	70,57,	
72,57,	0,0,	0,0,	0,0,	
0,0,	0,0,	72,57,	72,70,	
72,57,	72,59,	72,59,	72,59,	
72,59,	72,59,	72,59,	72,59,	
72,59,	72,59,	72,59,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
74,57,	0,0,	0,0,	0,0,	
72,57,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
75,75,	0,0,	75,60,	0,0,	
0,0,	75,60,	0,0,	0,0,	
0,0,	0,0,	0,0,	75,60,	
75,83,	75,60,	75,77,	75,77,	
75,77,	75,77,	75,77,	75,77,	
75,77,	75,77,	75,77,	75,77,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	75,60,	75,60,	75,60,	
75,60,	77,60,	0,0,	77,60,	
0,0,	75,60,	77,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
77,60,	77,83,	77,60,	77,77,	
77,77,	77,77,	77,77,	77,77,	
77,77,	77,77,	77,77,	77,77,	
77,77,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	77,60,	77,60,	
77,60,	77,60,	83,60,	0,0,	
83,60,	0,0,	77,60,	83,60,	
0,0,	0,0,	0,0,	0,0,	
0,0,	83,60,	83,83,	83,60,	
83,77,	83,77,	83,77,	83,77,	
83,77,	83,77,	83,77,	83,77,	
83,77,	83,77,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	83,60,	
83,60,	83,60,	83,60,	0,0,	
0,0,	0,0,	0,0,	83,60,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+-2,	0,		0,	
yycrank+-12,	yysvec+3,	0,	
yycrank+-43,	0,		0,	
yycrank+-9,	yysvec+5,	0,	
yycrank+-114,	0,		0,	
yycrank+0,	yysvec+7,	0,	
yycrank+-155,	0,		0,	
yycrank+0,	yysvec+9,	0,	
yycrank+177,	0,		0,	
yycrank+0,	yysvec+11,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+238,	0,		yyvstop+10,
yycrank+0,	yysvec+16,	yyvstop+13,
yycrank+34,	0,		yyvstop+18,
yycrank+328,	0,		yyvstop+22,
yycrank+328,	yysvec+16,	yyvstop+26,
yycrank+3,	yysvec+16,	yyvstop+31,
yycrank+188,	yysvec+16,	yyvstop+34,
yycrank+405,	yysvec+16,	yyvstop+38,
yycrank+0,	0,		yyvstop+43,
yycrank+0,	0,		yyvstop+47,
yycrank+0,	0,		yyvstop+51,
yycrank+494,	0,		yyvstop+55,
yycrank+2,	yysvec+27,	yyvstop+59,
yycrank+0,	0,		yyvstop+63,
yycrank+0,	0,		yyvstop+67,
yycrank+0,	0,		yyvstop+71,
yycrank+7,	0,		yyvstop+73,
yycrank+0,	yysvec+32,	yyvstop+76,
yycrank+0,	yysvec+32,	yyvstop+78,
yycrank+0,	0,		yyvstop+80,
yycrank+9,	0,		yyvstop+83,
yycrank+0,	0,		yyvstop+86,
yycrank+0,	0,		yyvstop+89,
yycrank+0,	0,		yyvstop+92,
yycrank+24,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+98,
yycrank+0,	0,		yyvstop+100,
yycrank+0,	0,		yyvstop+103,
yycrank+0,	0,		yyvstop+105,
yycrank+0,	0,		yyvstop+107,
yycrank+0,	0,		yyvstop+109,
yycrank+0,	0,		yyvstop+112,
yycrank+0,	0,		yyvstop+114,
yycrank+0,	0,		yyvstop+117,
yycrank+0,	0,		yyvstop+119,
yycrank+0,	0,		yyvstop+121,
yycrank+0,	0,		yyvstop+123,
yycrank+120,	0,		yyvstop+125,
yycrank+0,	0,		yyvstop+127,
yycrank+0,	0,		yyvstop+129,
yycrank+0,	yysvec+16,	0,	
yycrank+0,	yysvec+16,	yyvstop+131,
yycrank+6,	yysvec+16,	yyvstop+134,
yycrank+11,	yysvec+16,	0,	
yycrank+583,	yysvec+16,	yyvstop+137,
yycrank+6,	0,		0,	
yycrank+1,	0,		0,	
yycrank+8,	0,		0,	
yycrank+27,	0,		0,	
yycrank+0,	0,		yyvstop+139,
yycrank+29,	0,		0,	
yycrank+0,	yysvec+66,	0,	
yycrank+83,	0,		0,	
yycrank+0,	yysvec+68,	0,	
yycrank+640,	yysvec+27,	yyvstop+141,
yycrank+0,	0,		yyvstop+144,
yycrank+697,	yysvec+27,	yyvstop+146,
yycrank+0,	yysvec+27,	yyvstop+149,
yycrank+754,	yysvec+16,	yyvstop+151,
yycrank+778,	yysvec+16,	0,	
yycrank+36,	yysvec+27,	yyvstop+153,
yycrank+835,	yysvec+16,	0,	
yycrank+1,	yysvec+27,	yyvstop+155,
yycrank+0,	yysvec+32,	0,	
yycrank+0,	yysvec+36,	yyvstop+157,
yycrank+0,	0,		yyvstop+159,
yycrank+0,	yysvec+40,	yyvstop+161,
yycrank+892,	yysvec+16,	yyvstop+163,
yycrank+0,	0,		yyvstop+165,
yycrank+30,	0,		0,	
yycrank+0,	0,		yyvstop+167,
yycrank+0,	0,		yyvstop+169,
yycrank+1,	yysvec+27,	yyvstop+171,
yycrank+0,	0,		yyvstop+173,
yycrank+6,	yysvec+27,	yyvstop+175,
yycrank+2,	yysvec+27,	yyvstop+177,
yycrank+14,	yysvec+27,	yyvstop+179,
yycrank+0,	0,		yyvstop+181,
0,	0,	0};
struct yywork *yytop = yycrank+987;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
  0,   1,   1,   1,   1,   1,   1,   1, 
  1,   9,  10,   1,  12,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  9,  33,  34,   1,  36,   1,  33,  39, 
 40,  41,  33,  33,   1,  39,  46,  39, 
 48,  49,  49,  49,  49,  49,  49,  49, 
 49,  49,   1,   1,  33,  33,  33,   1, 
 33,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,   1,  33,   1,  33,  39, 
  1,  97,  97,  99,  97,  97,  97,  97, 
 97,  97,  97,  97,  97, 109,  97,  97, 
109,  97,  99, 109,  97,  99,  97,  97, 
 97,  97,  97,   1,   1,   1,  33,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
0};
char yyextra[] = {
0,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)ncform	6.12	97/12/08 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
#ifndef __cplusplus
			*yylastch++ = yych = input();
#else
			*yylastch++ = yych = lex_input();
#endif
#ifdef YYISARRAY
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
#else
			if (yylastch >= &yytext[ yytextsz ]) {
				int	x = yylastch - yytext;

				yytextsz += YYTEXTSZINC;
				if (yytext == yy_tbuf) {
				    yytext = (char *) malloc(yytextsz);
				    memcpy(yytext, yy_tbuf, sizeof (yy_tbuf));
				}
				else
				    yytext = (char *) realloc(yytext, yytextsz);
				if (!yytext) {
				    fprintf(yyout,
					"Cannot realloc yytext\n");
				    exit(1);
				}
				yylastch = yytext + x;
			}
#endif
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (uintptr_t)yyt > (uintptr_t)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((uintptr_t)yyt < (uintptr_t)yycrank) {	/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
#ifndef __cplusplus
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
#else
		yyprevious = yytext[0] = lex_input();
		if (yyprevious>0)
			lex_output(yyprevious);
#endif
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
#ifndef __cplusplus
	return(input());
#else
	return(lex_input());
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
#ifndef __cplusplus
	output(c);
#else
	lex_output(c);
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
