#include <stdlib.h>
#include <malloc.h>
#include <X11/xpm.h>
#include <stdio.h>
#include "list.h"
#include "leds.h"
#include "wmgeneral.h"

ListItem leds_array;
point Red_led,Yellow_led,Off_led,Green_led,Blue_led,Purple_led;


int init_leds(int led_offx, int led_offy,
	int led_redx, int led_redy,
	int led_yellowx, int led_yellowy,
	int led_greenx, int led_greeny,
	int led_bluex,int led_bluey,
	int led_purplex,int led_purpley)
{
	if (!ListInit(&leds_array))
		return -1;
		
	Off_led.x = led_offx; Off_led.y = led_offy;
	Red_led.x = led_redx; Red_led.y = led_redy;
	Yellow_led.x = led_yellowx; Yellow_led.y = led_yellowy;
	Green_led.x = led_greenx; Green_led.y = led_greeny;
	Blue_led.x = led_bluex; Blue_led.y = led_bluey;
	Purple_led.x = led_purplex; Purple_led.y = led_purpley;
	return 0;
}

struct led *add_led(int x,int y, int status)
{
	struct led *led;
	led=(struct led*)(malloc(sizeof(struct led)));
	if (!led) 
		return 0;
	led->x=x;
	led->y=y;
	led->current_status=status;
	led->last_status=-1; /* force display */
	ListInsert(&leds_array,led);
	return led;
}

int display_leds(int force_redraw)
{
	ListItem iterator;
	
	struct led *cled;
	point *color;
	
	int changed=0;
	
	for (iterator=leds_array; iterator; iterator=iterator->next) {
		cled=(struct led*)ListData(iterator);
	
		if (force_redraw || (cled->current_status != cled->last_status) || 
			(cled->current_status & LED_FLASHING)) {
			/* copy led */
			changed=1;		
			cled->last_status=cled->current_status;
			
			if (cled->current_status & LED_FLASHING) {
				if (cled->current_status & LED_FLASH_ON)
					cled->current_status&=~LED_FLASH_ON;
				else 
					cled->current_status|=LED_FLASH_ON;
			}
			switch(cled->current_status & 0x0F) {
				case LED_RED: color=&Red_led; break;
				case LED_YELLOW: color=&Yellow_led; break;
				case LED_GREEN: color=&Green_led; break;
				case LED_BLUE: color=&Blue_led; break;
				case LED_PURPLE: color=&Purple_led; break;
				case LED_OFF: color=&Off_led; break;
				default: color=&Off_led;
			}
			if (cled->current_status & LED_FLASHING)
			  if (cled->current_status & LED_FLASH_ON) 
			  	color=&Off_led;
			  	
			/* Draw led */
			
			copyXPMArea(color->x, color->y, 4, 4,
					cled->x, cled->y);
		} 
	}
	return changed;
}

