/**
* wmBinClock.c by Thomas Kuiper <tkuiper@inxsoft.net>
*
* Copyright (C) 2003 Thomas Kuiper <tkuiper@inxsoft.net>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program (see the file COPYING); if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA  02111-1307, USA
*/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <math.h>
#include "xutils.h"
#include "wmBinClock_master.xpm"
#include "wmBinClock_mask.xbm"

#define GRAYX 64
#define GRAYY 2
#define NEONREDX 72
#define NEONREDY 2
#define GOLDX 80
#define GOLDY 2
#define CYANX 88
#define CYANY 2
#define PINKX 96
#define PINKY 2
#define BLUEX 104
#define BLUEY 2
#define GREENX 112
#define GREENY 2
#define DARKREDX 120
#define DARKREDY 2
#define NONEX 128
#define NONEY 2


/* 
 *  Delay between refreshes (in microseconds) 
 */
#define DELAY 10000L
#define DEFAULT_UPDATEDELAY 900L

void ButtonPressEvent(XButtonEvent *);
void KeyPressEvent(XKeyEvent *);
char *StringToUpper(char *);

int UpToDate = 0;
long UpdateDelay;
int GotFirstClick1, GotDoubleClick1;
int GotFirstClick2, GotDoubleClick2;
int GotFirstClick3, GotDoubleClick3;
int DblClkDelay;


int main(int argc, char *argv[])
{
    XEvent event;
    struct tm *tmworld;
	int coloron_x = NEONREDX;
	int coloron_y = NEONREDY;
	int coloroff_x = GRAYX;
	int coloroff_y = GRAYY;
    time_t t;
    char tempstr[20];
    int m;
    int clockarray[10][10];
    Window myWindow;
    int i, j;
    m = 101;

	if (argc >= 2)
	{
		if ((strcmp(argv[1],"-h") == 0) ||
			(strcmp(argv[1],"--help") == 0))
			{
			printf("Usage: %s [coloron] [coloroff] [-display]\n\n",argv[0]);
			printf("  Where [coloron] or [coloroff] are one off these colors:\n");
			printf("  gray neonred gold cyan pink blue green darkred none\n");
			printf("  The default is \"%s neonred gray\"\n",argv[0]);
			printf("  Option -display (host:screen): Use a alternative XWindow display\n");
			return 0;
			}

		if (strcmp(argv[1],"gray") == 0)
			{
			coloron_x = GRAYX;
			coloron_y = GRAYY;
			}
		else
		if (strcmp(argv[1],"neonred") == 0)
			{
			coloron_x = NEONREDX;
			coloron_y = NEONREDY;
			}
		else
		if (strcmp(argv[1],"gold") == 0)
			{
			coloron_x = GOLDX;
			coloron_y = GOLDY;
			}
		else
		if (strcmp(argv[1],"cyan") == 0)
			{
			coloron_x = CYANX;
			coloron_y = CYANY;
			}
		else
		if (strcmp(argv[1],"pink") == 0)
			{
			coloron_x = PINKX;
			coloron_y = PINKY;
			}
		else
		if (strcmp(argv[1],"blue") == 0)
			{
			coloron_x = BLUEX;
			coloron_y = BLUEY;
			}
		else
		if (strcmp(argv[1],"green") == 0)
			{
			coloron_x = GREENX;
			coloron_y = GREENY;
			}
		else
		if (strcmp(argv[1],"darkred") == 0)
			{
			coloron_x = DARKREDX;
			coloron_y = DARKREDY;
			}
		else
		if (strcmp(argv[1],"none") == 0)
			{
			coloron_x = NONEX;
			coloron_y = NONEY;
			}
	}
	if (argc >= 3)
	{
		if (strcmp(argv[2],"gray") == 0)
			{
			coloroff_x = GRAYX;
			coloroff_y = GRAYY;
			}
		else
		if (strcmp(argv[2],"neonred") == 0)
			{
			coloroff_x = NEONREDX;
			coloroff_y = NEONREDY;
			}
		else
		if (strcmp(argv[2],"gold") == 0)
			{
			coloroff_x = GOLDX;
			coloroff_y = GOLDY;
			}
		else
		if (strcmp(argv[2],"cyan") == 0)
			{
			coloroff_x = CYANX;
			coloroff_y = CYANY;
			}
		else
		if (strcmp(argv[2],"pink") == 0)
			{
			coloroff_x = PINKX;
			coloroff_y = PINKY;
			}
		else
		if (strcmp(argv[2],"blue") == 0)
			{
			coloroff_x = BLUEX;
			coloroff_y = BLUEY;
			}
		else
		if (strcmp(argv[2],"green") == 0)
			{
			coloroff_x = GREENX;
			coloroff_y = GREENY;
			}
		else
		if (strcmp(argv[2],"darkred") == 0)
			{
			coloroff_x = DARKREDX;
			coloroff_y = DARKREDY;
			}
		else
		if (strcmp(argv[2],"none") == 0)
			{
			coloroff_x = NONEX;
			coloroff_y = NONEY;
			}
	}

    initXwindow(argc, argv);
    myWindow =
	openXwindow(argc, argv, wmBinClock_master_xpm,
		    wmBinClock_mask_bits, wmBinClock_mask_width,
		    wmBinClock_mask_height);

    DblClkDelay = 32000;
    UpToDate = 0;
    while (1) {

	if (DblClkDelay > 15) {

	    DblClkDelay = 0;
	    GotFirstClick1 = 0;
	    GotDoubleClick1 = 0;
	    GotFirstClick2 = 0;
	    GotDoubleClick2 = 0;
	    GotFirstClick3 = 0;
	    GotDoubleClick3 = 0;

	} else {

	    ++DblClkDelay;

	}


	/* 
	 *   Process any pending X events.
	 */
	while (XPending(display)) {
	    XNextEvent(display, &event);
	    switch (event.type) {
	    case Expose:
		RedrawWindow();
		break;
	    case ButtonPress:
		ButtonPressEvent(&event.xbutton);
		break;
	    case KeyPress:
		KeyPressEvent(&event.xkey);
		break;
	    case ButtonRelease:
		break;
	    case EnterNotify:
		XSetInputFocus(display, PointerRoot, RevertToParent,
			       CurrentTime);
		break;
	    case LeaveNotify:
		XSetInputFocus(display, PointerRoot, RevertToParent,
			       CurrentTime);
		break;

	    }
	}



	copyXPMArea(5, 69, 54, 54, 5, 5);

	t = time(0);
	tmworld = localtime(&t);

	sprintf(tempstr, "%02i%02i%02i",
		tmworld->tm_hour, tmworld->tm_min, tmworld->tm_sec);

	for (i = 0; i < 6; i++) {
	    clockarray[i][0] = 0;
	    clockarray[i][1] = 0;
	    clockarray[i][2] = 0;
	    clockarray[i][3] = 0;

	    switch (tempstr[i]) {

	    case '1':
		clockarray[i][3] = 1;
		break;
	    case '2':
		clockarray[i][2] = 1;
		break;
	    case '3':
		clockarray[i][3] = 1;
		clockarray[i][2] = 1;
		break;
	    case '4':
		clockarray[i][1] = 1;
		break;
	    case '5':
		clockarray[i][3] = 1;
		clockarray[i][1] = 1;
		break;
	    case '6':
		clockarray[i][2] = 1;
		clockarray[i][1] = 1;
		break;
	    case '7':
		clockarray[i][3] = 1;
		clockarray[i][2] = 1;
		clockarray[i][1] = 1;
		break;
	    case '8':
		clockarray[i][0] = 1;
		break;
	    case '9':
		clockarray[i][0] = 1;
		clockarray[i][3] = 1;
		break;
	    }
	}
	for (i = 0; i < 6; i++) {
	    for (j = 0; j < 4; j++) {
		if (clockarray[i][j] == 1)
		    copyXPMArea(coloron_x, coloron_y, 8, 8, 6 + (i * 9),
				10 + (j * 10));
		else
		    copyXPMArea(coloroff_x, coloroff_y, 8, 8, 6 + (i * 9),
				10 + (j * 10));
	    }
	}

	RedrawWindow();

	usleep(DELAY);
    }
}




void ButtonPressEvent(XButtonEvent * xev)
{

    /*
     *  Process single clicks.
     */
    DblClkDelay = 0;
    if ((xev->button == Button1) && (xev->type == ButtonPress)) {

	if (GotFirstClick1)
	    GotDoubleClick1 = 1;
	else
	    GotFirstClick1 = 1;

    } else if ((xev->button == Button2) && (xev->type == ButtonPress)) {

	if (GotFirstClick2)
	    GotDoubleClick2 = 1;
	else
	    GotFirstClick2 = 1;

    } else if ((xev->button == Button3) && (xev->type == ButtonPress)) {

	if (GotFirstClick3)
	    GotDoubleClick3 = 1;
	else
	    GotFirstClick3 = 1;

    }




    /*
     *  We got a double click on Mouse Button1 (i.e. the left one)
     */
    if (GotDoubleClick1) {
	GotFirstClick1 = 0;
	GotDoubleClick1 = 0;
    }


    /*
     *  We got a double click on Mouse Button2 (i.e. the left one)
     */
    if (GotDoubleClick2) {
	GotFirstClick2 = 0;
	GotDoubleClick2 = 0;
    }


    /*
     *  We got a double click on Mouse Button3 (i.e. the left one)
     */
    if (GotDoubleClick3) {
	GotFirstClick3 = 0;
	GotDoubleClick3 = 0;
    }

    return;


}




/*
 *  This routine handles key presses.
 *
 */
void KeyPressEvent(XKeyEvent * xev)
{

    return;

}


