/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999



#ifndef _MUSIC_H
#define _MUSIC_H

#include <wftk/sound.h>
#include <wftk/resources.h>

#include <string>

namespace wftk {

/// Wrapper class for loading and playing music files (mp3, ogg, mod)
class Music : public Sound
{

public:

  /// default constructor
  Music();
  /// create music object from file on disk
  Music(const std::string& );
  ///
  virtual ~Music();
  
  ///
  virtual bool load(const std::string&);  
  ///
  virtual bool play(int loops = 0) const;

  /// set volume (0..100)
  virtual int setVolume(int vol);  
  /// cease playback
  virtual void stop() const;
  /// true if music is playing
  virtual bool playing() const;
  /// true if music is paused
  virtual bool paused() const;
  /// pause playback
  virtual void pause() const;
  /// rewind song to beginning
  virtual void rewind() const; 
  /// resume song (if paused)
  virtual void resume() const;

  /** Load Music resource from file
   *
   * Use the \b load() function to load an mp3 from a file on disk and 
   * register it with wftk's Resources engine, e.g.:
   * \code
   *   Music::registry.load("town_music", "town.mp3");
   * \endcode
   * 
   * Use the \b find() function to retrieve a pointer to the Music object.  If the
   * named object has not been registered, find() will return 0.
   * \code
   *   Music* noise = Music::registry.find("ambient");
   * \endcode
   *
   * Use the \c setMusic function from the Mixer class to play the given music within the
   * application:
   * \code
   *   wftk::Mixer::instance()->setMusic("town_music");
   * \endcode
   */
  static ResourceRegistry<Music*> registry;
  /// refcounted resource type
  typedef Resource<Music*> Resource;
    
 private:

  ///
  int channel_;

  ///
  void* data_; // Mix_Music*
};

}

#endif
