/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// June 1999


#ifndef _LISTBOX_H
#define _LISTBOX_H

#include <wftk/singlecontainer.h>
#include <wftk/label.h>

#include <map>

namespace wftk {

class Button;
class PushButton;
class Box;

/**
 * A multi-line selection with scroll bar.
 */
class ListBox : public SingleContainer
{
 //OBJECT

 public:
  /**
   * Default constructor
   */
  ListBox();

  /**
   * set the background color the ListBox, or the text color of the selected row
   *\param color a color ressource
   */
  void setColor(const Color& color);
  /**
   * set the color of the selected row
   *\param color a color ressource
   */
  void setSelectedColor(const Color& color);

  /**
   * get which element is selected
   *\return a std::string containing the selected element, or "" if nothing is
   *        selected
   */
  std::string getSelection() const {return selected_ ? selected_->getText() : "";}

  /**
   * add an element to the ListBox
   *\param data a string containing the element to add to the list
   */
  void addElement(const std::string& data );
  /**
   * add a list of elements to the ListBox
   *\param data a std::vector containing the strings with the element names
   */
  void addElements(const std::vector<std::string>& data);
  /**
   * empty the ListBox
   */
  void clear();
  /**
   * scroll up in the list
   */
  void scrollUp();
  /**
   * scroll down in the list
   */
  void scrollDown();
  
  /**
   * signal to send when the selection changes
   */
  SigC::Signal1<void, const std::string&> selectionChanged;
  
  /**
   * select this item 
   *\param item item to select
   */
  void setSelected(const std::string& item);  

 private:
  ///
  void setSelectedElement(ScreenArea*);
  ///
  void setSelectedLabel(Label*);
  ///
  void selected(Button*);
  ///
  void addElementImpl(const std::string&);
  ///
  PushButton* scrollUp_;
  ///
  PushButton* scrollDown_;
  ///
  Box* buttonBox_;
  ///
  typedef std::map<std::string,Label*> Elements;
  ///
  Elements elements_;
  ///
  bool lock_;
  ///
  Label* selected_;
  ///
  Color selectedCol_;
};  


}

#endif // !_LISTBOX_H
