/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "multilineedit.h"
#include "pushbutton.h"
#include "terminal.h"
#include "font.h"
#include "debug.h"
#include "rootwindow.h"
#include "box.h"
#include "filler.h"

#include "quitcheck.h"

using namespace wftk;

#include <iostream>

class TextApp : public QuitCheckApp
{
 public:

  TextApp(int argc, char** argv) : 
    QuitCheckApp(argc, argv)
    {
     std::cout << "starting up ..." <<std::endl;
      //do init here

      RootWindow* back = new RootWindow(640,480);
  
      RootWindow::instance()->setTitle("LIBWFTK Demo");


      // These font resources are used by various gui elements,
      // so you should always register text_font and button_font when
      // using wftk

      // colors are in the order RGB or ARGB.
      Font::registry.load("text_font","wf_opal.ttf, 16, 0xFFF0F0F0, 0xaa707070");
      Font::registry.load("button_font","wf_opal.ttf, 14, 0xE0E0F0FF, 0x607f70EE");

      //create your gui here

      Box *mainbox = new Box(Box::LEFT_TO_RIGHT);
      back->pack(mainbox);

      Box *leftbox = new Box(Box::TOP_TO_BOTTOM);
      mainbox->packBack(leftbox);

      leftbox->packBack(new MultiLineEdit("Demo of text capabilities\n"
					  "by Malcolm Walker\n",
					  Font::registry.find("text_font")));

      Terminal* info = new Terminal("This is a Terminal Widget.\n"
				    "You may type in here and use the scrollbar "
				    "on the right to scroll the content.\n",
				    Font::registry.find("button_font"), false);
      info->setColor(Color(0,100,50,128));
      leftbox->packBack(info);

      leftbox->packBack(new Filler(Filler::VERTICAL));

      back->setColor("lightgrey");

      Box *rightbox = new Box(Box::TOP_TO_BOTTOM);
      mainbox->packBack(rightbox);

      rightbox->packBack(new Filler(Filler::VERTICAL));

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      rightbox->packBack(quit_button);

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());
    }
};

int main (int argc, char **argv)
{
  Debug::init(Debug::GENERIC);

  return TextApp(argc, argv).exec();
}

