/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "progressdialog.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "box.h"

//this is a non-modal dialog

wftk::ProgressDialog::ProgressDialog(const std::string& label, 
				     const std::string& border_res_name,
				     const Font& font) :
  BorderedDialog("", border_res_name)
{
  getResourceBackground("progressdialog");

  Box* box = new Box(Box::TOP_TO_BOTTOM);
  pack(box);

  bar_ = new ProgressBar();
  box->packBack(bar_);
  bar_->getResourceBackground("progressdialog_bar");

  box->packBack(new Label(label, font));
}

void wftk::ProgressBar::setValue(Uint8 data)
{
  percentage_ = (data < 100) ? data  : 100;

  // change the 'shape' to reflect the progress
  handleResize(width(), height());
}

void wftk::ProgressBar::handleResize(Uint16 w, Uint16 h)
{
  // we set the shape of the bar to show the amount of progress

  Rect shape(0, 0, 1 + (percentage_ * (w - 1)) / 100, h);

  setShape(shape, isOpaque() ? shape : Rect(0, 0, 0, 0));
}

void wftk::ProgressBar::setPackingInfo()
{
  Widget::setPackingInfo();

  packing_info_.x.filler = PackingInfo::Expander::FILL;
}

void wftk::ProgressDialog::setPackingInfo()
{
  Dialog::setPackingInfo();

  // With the widgets in the dialog, the label sets
  // the prefered width, and the progress bar expands
  // to it. Since we usually want a somewhat wider
  // dialog, we change the prefered width here.

  if(parent()) {
    unsigned nice_width = parent()->width() / 2;

    if(packing_info_.x.pref < nice_width)
      packing_info_.x.pref = nice_width;
  }
}

