#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`

# name of the current package
PKG_NAME=`basename \`(cd $srcdir; pwd)\``

# default configure options
conf_flags="--enable-debug"

DIE=0
libtool=0
gettext=0

missing() {
  echo
  echo "**Error**: You must have \`$1' installed to compile $PKG_NAME."
  echo "Download the appropriate package for your distribution,"
  echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
  DIE=1
}

mygettextize() {
  local version=$(gettextize --version | sed -n '1s/.* //p')
  local major=$(echo $version | sed 's/^\([^.]*\)\..*/\1/')
  local minor=$(echo $version | sed 's/^[^.]*\.\([^.]*\)\..*/\1/')
  local version=$(gettextize --version | sed -n '1s/.* //;s/^.*\.\(.*\)\..*$/\1/;p;q')
  if test "$major" -eq 0 -a "$minor" -lt 11; then
    echo "no" | gettextize --force --copy
  else
    gettextize --no-changelog --intl --force --copy
    # restore the old files that should not have been modified
    cp Makefile.am~ Makefile.am
    cp configure.in~ configure.in
  fi
}

(automake --version) < /dev/null > /dev/null 2>&1 || missing automake

(autoconf --version) < /dev/null > /dev/null 2>&1 || missing autoconf

grep "^AM_GNU_GETTEXT" $srcdir/configure.in >/dev/null && gettext=1
grep "^AM_PROG_LIBTOOL" $srcdir/configure.in >/dev/null && libtool=1

if test "$gettext" -eq 1; then
  grep "sed.*POTFILES" $srcdir/configure.in >/dev/null || \
  (gettextize --version) < /dev/null > /dev/null 2>&1 || missing gettext
fi

if test "$libtool" -eq 1; then
  (libtoolize --version) < /dev/null > /dev/null 2>&1 || missing libtool
fi

if test "$DIE" -eq 1; then
  exit 1
fi

if test -z "$*"; then
  echo "**Warning**: I am going to run \`configure' with default arguments."
  echo "If you wish to pass any others to it, please specify them on the"
  echo \`$0\'" command line."
  echo
else
  unset conf_flags
fi

if test "$gettext" -eq 1; then
  # Apparently, gettextize should not be used automatically, thus not here.
  # See autopoint instead? RV@@8
  echo "Running gettextize...  Ignore non-fatal messages."
  mygettextize

  if test -d $srcdir/po -a ! -f $srcdir/po/POTFILES.in ; then
    echo "Creating $srcdir/po/POTFILES.in..."
    find $srcdir \( -path "./intl" -o -path "./po" \) -prune -o \
      -name "*.cc" -fprintf po/POTFILES.in "%P\n"
  fi
fi

if test  "$libtool" -eq 1; then
  echo "Running libtoolize..."
  libtoolize --force --copy
fi

echo "Running aclocal..."
aclocal
echo "Running autoheader..."
autoheader
echo "Running automake..."
automake
echo "Running autoconf ..."
autoconf

if test "x$NOCONFIGURE" = "x"; then
  echo Running $srcdir/configure $conf_flags "$@" ...
  $srcdir/configure $conf_flags "$@" &&
  echo Now type \`make\' to compile $PKG_NAME
else
  echo Skipping configure process.
fi
