/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <Logger.h>
#include <Setup.h>

#include <iostream>

using namespace std;

const QString Logger::theTraceLevelText[] = { "ERROR", "WARNING", "INFO", "DEBUG" };
Logger::TraceLevel Logger::theTraceLevel = Logger::ERROR;

void Logger::setTraceLevel(TraceLevel level)
{
  if ((level>=ERROR) && (level<=DEBUG))
  theTraceLevel = level;
}

void Logger::debug(const QString& message)
{
  logMessage(DEBUG, message);
}

void Logger::info(const QString& message)
{
  logMessage(INFO, message);
}

void Logger::warning(const QString& message)
{
  logMessage(WARNING, message);
}

void Logger::error(const QString& message)
{
  logMessage(ERROR, message);
}

void Logger::logMessage(TraceLevel traceLevel, const QString& message)
{
	if (traceLevel<=theTraceLevel)
	{
		cout << theTraceLevelText[traceLevel] << "\t:  " << message << endl;
	}
}
