/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef BLOCK1PORT_H
#define BLOCK1PORT_H

#include <Component.h>

#include <DataPoint.h>

#include <qpixmap.h>

class Block1Port : public Component
{
public:
  Block1Port( const QPoint& center );
  virtual ~Block1Port();

  virtual void initComponent();
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn );

  virtual const QString& getCatagory() const;
  virtual const QString& getName() const;
  virtual const QPixmap& getPixmap() const;

  virtual bool initSweep();

protected:
  virtual void drawSymbol(QPainter*);

private:
  static QPixmap* pixmap_;
  QString name_;
  QList<DataPoint>* schematicData_;
  QList<DataPoint>* fileData_;
};

#endif
