#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "v3dmp.h"
#include "v3dmodel.h"

#include "guiutils.h"
#include "cdialog.h"

#include "editor.h"
#include "editorcb.h"
#include "editorselect.h"
#include "editorviewcb.h"
#include "editorlist.h"
#include "editorundo.h"
#include "editortexture.h"
#include "editorhf.h"
#include "editorp.h"
#include "editorpcb.h"

#include "vma.h"
#include "vmautils.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif



void EditorPrimitivePrimPaletteCreateCB(
	gpointer data, gint ptype, gpointer p
);
void EditorPrimitiveCreateCommentCB(
	GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTranslateCB(
	GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateUntranslateCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateRotateCB(
	GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateUnrotateCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreatePointCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateLineCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateLineStripCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateLineLoopCB( 
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTriangleCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTriangleStripCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTriangleFanCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateQuadCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateQuadStripCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreatePolygonCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateColorCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTextureSelectCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTextureOrientXYCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTextureOrientYZCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTextureOrientXZCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateTextureOffCB(
        GtkWidget *widget, gpointer data
);
void EditorPrimitiveCreateHeightFieldLoadCB(
        GtkWidget *widget, gpointer data
);

void EditorPrimitiveDeleteCB(GtkWidget *widget, gpointer data);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))

#define RADTODEG(r)	((r) * 180 / PI)
#define DEGTORAD(d)	((d) * PI / 180.0)


/*
 *      Checks if editor has changes, if it does not then it will
 *      mark it as having changes.
 */
#define EDITOR_DO_UPDATE_HAS_CHANGES    \
{ \
 if(!editor->has_changes) \
  editor->has_changes = TRUE; \
}


/*
 *	Callback to create primitive from primitives palette.
 */
void EditorPrimitivePrimPaletteCreateCB(
        gpointer data, gint ptype, gpointer p
)
{
	void *new_p;
	ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

	if(!editor->initialized || editor->processing)
	    return;

        if(VMAWriteProtectCheck(editor))
            return;

	/* Make a copy of the given referance primitive if avialable. */
	if(p == NULL)
	    new_p = NULL;
	else
	    new_p = V3DMPDup(p);

	/* Create new primitive. */
	EditorPrimitiveDoCreateSimple(
	    editor,
	    ptype,
	    -2,		/* Create at best position. */
	    new_p	/* Primitive to be transfered. */
	);
	new_p = NULL;

	return;
}

/*
 *	Create comment primitive callback.
 */
void EditorPrimitiveCreateCommentCB(GtkWidget *widget, gpointer data)
{
        int ptype = V3DMP_TYPE_COMMENT;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

	if(editor->processing)
	    return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
	    ptype,
            -2,         /* Create at best position. */
            NULL	/* Create default primitive of ptype. */
        );

	return;
}

/*
 *	Create translate primitive callback.
 */
void EditorPrimitiveCreateTranslateCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TRANSLATE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype, 
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

	return;
}

/*
 *      Create untranslate primitive callback.
 */
void EditorPrimitiveCreateUntranslateCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_UNTRANSLATE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;
        
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype, 
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );
        
        return;
}

/*
 *	Create rotate primitive callback.
 */
void EditorPrimitiveCreateRotateCB( 
	GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_ROTATE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;
        
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );
  
        return;
}

/*
 *      Create unrotate primitive callback.
 */
void EditorPrimitiveCreateUnrotateCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_UNROTATE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *      Create point primitive callback.
 */
void EditorPrimitiveCreatePointCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_POINT;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
 
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
        
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create line primitive callback.
 */
void EditorPrimitiveCreateLineCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_LINE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
 
        if(editor->processing)
            return;
        
        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype, 
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create line strip primitive callback.
 */
void EditorPrimitiveCreateLineStripCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_LINE_STRIP;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;
        
        if(VMAWriteProtectCheck(editor))
            return;
        
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype, 
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}  

/*
 *	Create line loop primitive callback.
 */
void EditorPrimitiveCreateLineLoopCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_LINE_LOOP;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;
        
        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype, 
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}  

/*
 *	Create triangle primitive callback.
 */
void EditorPrimitiveCreateTriangleCB(   
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TRIANGLE;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create triangle strip primitive callback.
 */
void EditorPrimitiveCreateTriangleStripCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TRIANGLE_STRIP;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create triangle fan primitive callback.
 */
void EditorPrimitiveCreateTriangleFanCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TRIANGLE_FAN;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create quad primitive callback.
 */
void EditorPrimitiveCreateQuadCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_QUAD;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create quad strip primitive callback.
 */
void EditorPrimitiveCreateQuadStripCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_QUAD_STRIP;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}  

/*
 *	Create polygon primitive callback.
 */
void EditorPrimitiveCreatePolygonCB(    
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_POLYGON;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create color primitive callback.
 */
void EditorPrimitiveCreateColorCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_COLOR;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/* 
 *	Create texture select callback.
 */
void EditorPrimitiveCreateTextureSelectCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TEXTURE_SELECT;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
            
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create texture orient XY callback.
 */
void EditorPrimitiveCreateTextureOrientXYCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TEXTURE_ORIENT_XY;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create texture orient YZ callback.
 */
void EditorPrimitiveCreateTextureOrientYZCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TEXTURE_ORIENT_YZ;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create texture orient XZ callback.
 */
void EditorPrimitiveCreateTextureOrientXZCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TEXTURE_ORIENT_XZ;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *	Create texture off callback.
 */
void EditorPrimitiveCreateTextureOffCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_TEXTURE_OFF;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;
  
        if(editor->processing)
            return;
  
        if(VMAWriteProtectCheck(editor))
            return;
  
        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}

/*
 *      Create heightfield load callback.
 */
void EditorPrimitiveCreateHeightFieldLoadCB(
        GtkWidget *widget, gpointer data
)
{
        int ptype = V3DMP_TYPE_HEIGHTFIELD_LOAD;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;

        if(editor->processing)
            return;

        if(VMAWriteProtectCheck(editor))
            return;

        EditorPrimitiveDoCreateSimple(
            editor,
            ptype,
            -2,         /* Create at best position. */
            NULL        /* Create default primitive of ptype. */
        );

        return;
}



/*
 *	Delete primitive(s) callback.
 */
void EditorPrimitiveDeleteCB(GtkWidget *widget, gpointer data)
{
	int *s, t;
        ma_editor_struct *editor = (ma_editor_struct *)data;
        if(editor == NULL)
            return;     

	/* Duplicate selections list for input (just to be safe). */
	t = editor->total_selected_primitives;
	s = (int *)((t > 0) ?
	    malloc(t * sizeof(int)) : NULL
	);
	if(s == NULL)
	    t = 0;
	else if(editor->selected_primitive != NULL)
	    memcpy(s, editor->selected_primitive, t * sizeof(int));

	/* Call delete primitives procedure. */
	EditorPrimitiveDoDelete(
	    editor, EditorSelectedModelIndex(editor), s, t,
	    TRUE	/* Record undo. */
	);

	/* Deallocate locally allocated selections list. */
	free(s);

	return;
}
