#!/usr/local/bin/perl
# index.cgi
# List the mail messages for the user

require './mailbox-lib.pl';
&ReadParse();

dbmopen(%read, "$user_module_config_directory/read", 0600);
&open_dsn_hash();

print "Refresh: $userconfig{'refresh'}\r\n"
	if ($userconfig{'refresh'});
&ui_print_header(undef, $text{'mail_title'}, "", undef, 1, 1);
print &check_clicks_function();

@folders = &list_folders_sorted();
if (!defined($in{'folder'}) && $userconfig{'default_folder'}) {
	$df = &find_named_folder($userconfig{'default_folder'}, \@folders);
	$in{'folder'} = $df->{'index'} if ($df);
	}
($folder) = grep { $_->{'index'} == $in{'folder'} } @folders;

# Check if this is a POP3 or IMAP inbox with no login set
if (($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
    $folder->{'mode'} == 3 && !defined($folder->{'user'})) {
	print "<form action=inbox_login.cgi method=post>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'mail_loginheader'}</b></td> </tr>\n";
	print "<tr $cb> <td align=middle>",&text('mail_logindesc',
			"<tt>$folder->{'server'}</tt>"),"\n";
	print "<table>\n";

	print "<tr> <td><b>$text{'mail_loginuser'}</b></td>\n";
	print "<td><input name=user size=30 value='$remote_user'></td> </tr>\n";
	print "<tr> <td><b>$text{'mail_loginpass'}</b></td>\n";
	print "<td><input type=password name=pass size=30></td> </tr>\n";
	if ($folder->{'type'} == 4) {
		print "<tr> <td valign=top><b>$text{'mail_loginmailbox'}",
		      "</b></td> <td>\n";
		printf"<input type=radio name=mailbox_def value=1 %s> %s<br>\n",
			"checked", $text{'edit_imapinbox'};
		printf"<input type=radio name=mailbox_def value=0> %s\n",
			$text{'edit_imapother'};
		print "<input name=mailbox size=20></td> </tr>\n";
		}

	print "<tr> <td colspan=2 align=center>\n";
	print "<input type=submit value='$text{'mail_login'}'>\n";
	print "<input type=reset value='$text{'mail_reset'}'></td> </tr>\n";
	print "</table></td></tr></table></form>\n";

	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Get folder-selection HTML
$sel = &folder_select(\@folders, $folder, "folder");

# Work out start from jump page
$perpage = $folder->{'perpage'} || $userconfig{'perpage'} || 20;
if ($in{'jump'} =~ /^\d+$/ && $in{'jump'} > 0) {
	$in{'start'} = ($in{'jump'}-1)*$perpage;
	}

# View mail from the most recent
@mail = reverse(&mailbox_list_mails(-$in{'start'},
				    -$in{'start'}-$perpage+1,
				    $folder, 1, \@error));
if ($in{'start'} >= @mail && $in{'jump'}) {
	# Jumped too far!
	$in{'start'} = @mail - $perpage;
	@mail = reverse(&mailbox_list_mails(-$in{'start'},
					    -$in{'start'}-$perpage+1,
					    $folder, 1, \@error));
	}

# Show page flipping arrows
&show_arrows();

print "<form action=delete_mail.cgi method=post>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
print "<input type=hidden name=mod value=",&modification_time($folder),">\n";
print "<input type=hidden name=start value='$in{'start'}'>\n";
if ($userconfig{'top_buttons'} && @mail) {
	&show_buttons(1);
	print &select_all_link("d", 1, $text{'mail_all'}),"&nbsp;\n";
	print &select_invert_link("d", 1, $text{'mail_invert'}),"&nbsp;\n";
	}

$showto = $folder->{'sent'} || $folder->{'drafts'};
if (@mail) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td>&nbsp;</td> ",
	      $showto ? "<td><b>$text{'mail_to'}</b></td>"
		       : "<td><b>$text{'mail_from'}</b></td> ",
	      $userconfig{'show_to'} ? $showto ?
			"<td><b>$text{'mail_from'}</b></td>" :
			"<td><b>$text{'mail_to'}</b></td>" : "",
	      "<td><b>$text{'mail_date'}</b></td> ",
	      "<td><b>$text{'mail_size'}</b></td> ",
	      "<td><b>$text{'mail_subject'}</b></td> </tr>\n";
	}
if (@error) {
	print "<center><b><font color=#ff0000>\n";
	print &text('mail_err', $error[0] == 0 ? $error[1] :
			      &text('save_elogin', $error[1])),"\n";
	print "</font></b></center>\n";
	}
elsif (@error && $error[0] == 2) {
	}

for($i=$in{'start'}; $i<@mail && $i<$in{'start'}+$perpage; $i++) {
	&notes_decode($mail[$i], $folder);
	local $idx = $mail[$i]->{'idx'};
	print "<tr $cb>\n";
	if (&editable_mail($mail[$i])) {
		print "<td><input type=checkbox name=d value=$idx></td>\n";
		}
	else {
		print "<td><br></td>\n";
		}
	print "<td nowrap><a href='view_mail.cgi?idx=$idx&folder=$folder->{'index'}'>",
              &simplify_from($mail[$i]->{'header'}->{$showto ? 'to' : 'from'}),
	      "</td>\n";
	if ($userconfig{'show_to'}) {
		print "<td nowrap>",&simplify_from(
	   		$mail[$i]->{'header'}->{$showto ? 'from' : 'to'}),
			"</td>\n";
		}
	print "<td nowrap>",&simplify_date($mail[$i]->{'header'}->{'date'}),
	      "</td>\n";
	print "<td nowrap>",&nice_size($mail[$i]->{'size'}, 1024),"</td>\n";
	print "<td><table border=0 cellpadding=0 cellspacing=0 width=100%>",
	      "<tr><td>",&simplify_subject($mail[$i]->{'header'}->{'subject'}),
	      "</td> <td align=right>";
	if ($mail[$i]->{'header'}->{'content-type'} =~ /multipart\/\S+/i) {
		print "<img src=images/attach.gif>";
		}
	local $p = int($mail[$i]->{'header'}->{'x-priority'});
	if ($p == 1) {
		print "&nbsp;<img src=images/p1.gif>";
		}
	elsif ($p == 2) {
		print "&nbsp;<img src=images/p2.gif>";
		}
	local $mid = $mail[$i]->{'header'}->{'message-id'};
	if (!$showto) {
		# Show icon if read by user
		if ($read{$mid} == 2) {
			print "&nbsp;<img src=images/special.gif>";
			}
		elsif ($read{$mid} == 1) {
			print "&nbsp;<img src=images/read.gif>";
			}
		}
	else {
		# Show icons if DSNs received
		if ($dsnreplies{$mid}) {
			print "<img src=images/dsn.gif>";
			}
		if ($delreplies{$mid}) {
			local ($bounce) = grep { /^\!/ }
				split(/\s+/, $delreplies{$mid});
			local $img = $bounce ? "red.gif" : "box.gif";
			print "&nbsp;<img src=images/$img>";
			}
		}
	print "</td></tr></table></td> </tr>\n";
	&update_delivery_notification($mail[$i], $folder);
	}
if (@mail) {
	print "</table>\n";
	print &select_all_link("d", 1, $text{'mail_all'}),"&nbsp;\n";
	print &select_invert_link("d", 1, $text{'mail_invert'}),"<br>\n";
	}

&show_buttons(2);
print "</form>\n";
if ($userconfig{'arrows'}) {
	# Show page flipping arrows
	print "<br>\n";
	&show_arrows();
	}

# Show search form
print "<hr>\n";
print "<table width=100%><tr>\n";
print "<form action=mail_search.cgi><td width=33%>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
print "<input type=hidden name=simple value=1>\n";
print "<input type=submit value='$text{'mail_search2'}'>\n";
print "<input name=search size=20></td></form>\n";

$jumpform = (@mail > $perpage);
print "<form action=search_form.cgi>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
print "<td width=33% align=center><input type=submit name=advanced ",
      "value='$text{'mail_advanced'}'></td>\n";
print "</form>\n";

# Show page jump form
if ($jumpform) {
	print "<form action=index.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td width=33% align=right>\n";
	print "<input type=submit value='$text{'mail_jump'}'>\n";
	printf "<input name=jump size=3 value='%s'> %s %s\n",
		int($in{'start'} / $perpage)+1, $text{'mail_of'},
		int(@mail / $perpage)+1;
	print "</td></form>\n";
	}
else {
	print "<td width=33% align=right></td>\n";
	}
print "</tr>\n";

# Show various buttons for the address book, folders, sig and logging out
$logout = ($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
	  $folder->{'mode'} == 3 && defined($folder->{'user'});
print "<tr>\n";

print "<form action=list_addresses.cgi>\n";
print "<td align=left width=33%><input type=submit value='$text{'mail_addresses'}'></td>\n";
print "</form>\n";

print "<form action=list_folders.cgi>\n";
print "<td align=",($bc == 2 ? "right" : "center"),
      " width=33%><input type=submit value='$text{'mail_folders'}'></td>\n";
print "</form>\n";

if (&get_signature_file()) {
	print "<form action=edit_sig.cgi>\n";
	print "<td width=33% align=right>",
	      "<input type=submit value='$text{'mail_sig'}'></td>\n";
	print "</form>\n";
	}
else {
	print "<td width=33% align=right></td>\n";
	}
print "</tr>\n";

print "<tr>\n";
if ($folder->{'trash'} || $userconfig{'show_delall'}) {
	# Show button to delete all mail in folder
	print "<form action=delete_mail.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<input type=hidden name=all value=1>\n";
	print "<td width=33%><input type=submit value='",
		($folder->{'trash'} ? $text{'mail_deltrash'}
				    : $text{'mail_delall'}),"'></td>\n";
	print "</form>\n";
	}
else {
	print "<td width=33%></td>\n";
	}

print "<td align=center width=33%></td>\n";

if ($logout) {
	# Add button for logging out of inbox
	print "<form action=inbox_logout.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td align=right><input type=submit value='",
		$folder->{'type'} == 2 ? $text{'mail_logout'} :
					 $text{'mail_logout2'},"'></td>\n";
	print "</form>\n";
	}
print "</tr>\n";

print "</table>\n";

&ui_print_footer("/", $text{'index'});
&pop3_logout();

# show_buttons(number)
sub show_buttons
{
local $spacer = "&nbsp;\n";
if (@mail) {
	print "<input type=submit name=delete value=\"$text{'mail_delete'}\" ",
	      "onClick='return check_clicks(form)'>";
	print $spacer;

	print "<input type=submit name=mark$_[0] value=\"$text{'mail_mark'}\">";
	print "<select name=mode$_[0]>\n";
	print "<option value=1 checked>$text{'mail_mark1'}\n";
	print "<option value=0>$text{'mail_mark0'}\n";
	print "<option value=2>$text{'mail_mark2'}\n";
	print "</select>";
	print $spacer;

	if (@folders > 1) {
		print &movecopy_select($_[0], \@folders, $folder);
		print $spacer;
		}

	print "<input type=submit name=forward value=\"$text{'mail_forward'}\">";
	print $spacer;
	}
print "<input type=submit name=new value=\"$text{'mail_compose'}\">";
print "<br>\n";
}

sub show_arrows
{
print "<center>\n";
print "<form action=index.cgi><font size=+1>\n";
if ($in{'start'}+$perpage < @mail) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}+$perpage, $in{'folder'},
		'<img src=/images/left.gif border=0 align=middle>';
	}

local $s = @mail-$in{'start'};
local $e = @mail-$in{'start'}-$perpage+1;
if (@mail) {
	print &text('mail_pos', $s, $e < 1 ? 1 : $e, scalar(@mail), $sel);
	}
else {
	print &text('mail_none', $sel);
	}
print "</font><input type=submit value='$text{'mail_fchange'}'>\n";

if ($in{'start'}) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}-$perpage, $in{'folder'},
		'<img src=/images/right.gif border=0 align=middle>';
	}
print "</form></center>\n";
}

