/*
 *  macdump/ mac address dumper
 *  Copyright 2002,2003 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
  MAC address dumping routine. 
  This application requires ROOT privilage to access all packets that 
  the host receives.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netpacket/packet.h>

#ifndef ETH_P_ALL
/* from linux kernel source */
#define ETH_P_ALL 0x0003
#endif

/* from linux kernel source */
#define ETH_P_IP 0x0800

int 
main(int ac, char ** av)
{
  //int s = socket (AF_INET, SOCK_PACKET, htons(ETH_P_IP));
  int s = socket (AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
  struct sockaddr_ll sll;
  unsigned char f[BUFSIZ+2];
  int ifindex;
  int count;
  perror("hello");
  
  ifindex = if_nametoindex(av[1]);
  
  memset(&sll, 0, sizeof(sll));
  sll.sll_family          = AF_PACKET;
  sll.sll_ifindex         = ifindex;
  sll.sll_protocol        = htons(ETH_P_ALL);
  if (bind(s, (struct sockaddr *) &sll, sizeof(sll)) == -1) 
    {
      exit(1);
    }

  while ((count=read(s,f,BUFSIZ)) >= 0)
    {
      /* first 6 bytes contain the MAC address of the packet sender. */
      if (count > 6)
	{
	  printf("%x:%x:%x:%x:%x:%x\n",f[0],f[1],f[2],f[3],f[4],f[5]);
	}      
    }
  return 0;
}
