ALTER TABLE twig_lhsqltable RENAME COLUMN lid TO lidold;
ALTER TABLE twig_lhsqltable ADD LID varchar(40) DEFAULT '0' NOT NULL;

ALTER TABLE twig_global_prefs ADD timeformat int4;
ALTER TABLE twig_mail_prefs ADD numup int4;

CREATE SEQUENCE twnoteid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twnoteid');

CREATE TABLE twig_notes (
	id		int4 DEFAULT nextval ( 'twnoteid' ),
        username        VARCHAR(20) NOT NULL,
        thedate         TIMESTAMP,
        groupid         INT4 NOT NULL,
        item            TEXT,
        description     TEXT,
        attachname      TEXT,
        attachment      TEXT
);

CREATE INDEX twig_notes_username_index ON twig_notes (username);

CREATE SEQUENCE twnotepid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twnotepid');

CREATE TABLE twig_notes_prefs (
	id		int4 DEFAULT nextval ( 'twnotepid' ),
	username	VARCHAR(20) NOT NULL,
	sortby		VARCHAR(10) NOT NULL,
	sortorder	int4 DEFAULT '0' NOT NULL,
	dgroup		int4 DEFAULT '0' NOT NULL,
	width		int4,
	height		int4
);

CREATE INDEX twig_notes_prefs_username_index ON twig_notes_prefs (username);

CREATE SEQUENCE twmeetid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twmeetid');

CREATE TABLE twig_meetings (
  	id 		int4 DEFAULT nextval ('twmeetid'),
  	groupid 	int4 DEFAULT '0' NOT NULL,
  	username 	varchar(20),
  	secretary	varchar(20),
  	responsible	varchar(20),
  	thedate 	TIMESTAMP,
  	itemstart 	TIMESTAMP,
  	itemstop 	TIMESTAMP,
  	itemdone 	TIMESTAMP,
  	item 		text,
  	description 	text,
  	minutes		text,
  	conclusion 	text,
  	actionitems 	text,
  	location	int4 DEFAULT '0' NOT NULL,
  	userlimit 	int4 DEFAULT '0' NOT NULL,
  	closed 		int4 DEFAULT '0' NOT NULL,
  	deleted 	int4 DEFAULT '0' NOT NULL,
  	private 	int4 DEFAULT '0' NOT NULL
);

CREATE INDEX twig_meetings_id_index ON twig_meetings (id);

CREATE SEQUENCE twmeetpid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twmeetpid');

CREATE TABLE twig_meetings_prefs (
  	id 		int4 DEFAULT nextval ('twmeetpid'),
  	username 	varchar(20),
  	dgroup 		int4 DEFAULT '0' NOT NULL,
  	mainview	int4 DEFAULT '0' NOT NULL,
  	pagesize	int4 DEFAULT '0' NOT NULL
);

CREATE INDEX twig_meetings_prefs_id_index ON twig_meetings_prefs (id);

CREATE SEQUENCE twmeetrid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twmeetrid');

CREATE TABLE twig_meetings_registration (
  	idx 		int4 DEFAULT nextval ('twmeetrid'),
  	user_idx 	varchar(20),
  	event_idx 	int4 DEFAULT '0' NOT NULL,
  	r_date 		TIMESTAMP,
  	rsvp 		int4 DEFAULT '0' NOT NULL,
  	PRIMARY KEY 	(idx)
);

CREATE INDEX twig_meetings_registration_id_index ON twig_meetings_registration (idx);
